/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Jul  9 23:05:29 2003 by Jeff Dalton
 * Copyright: (c) 2002, 2003, AIAI, University of Edinburgh
 */

package ix.icore.plan;

import java.util.*;

import ix.icore.*;
import ix.util.Name;

/**
 * Wraps an {@link ix.icore.Activity} when it appears in a plan.
 */
public class PlanNode extends AbstractPlanItem {

    protected Activity activity;

    public PlanNode() {
    }

    public PlanNode(Name id, Activity activity) {
	this.id = id;
	this.activity = activity;
    }

    public Activity getActivity() {
        return activity;
    }

    public TaskItem getItem() {
	return getActivity();
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    public void setItem(TaskItem item) {
	setActivity((Activity)item);
    }

}
