/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Oct 19 05:16:51 2006 by Jeff Dalton
 * Copyright: (c) 2005-2006, AIAI, University of Edinburgh
 */

package ix.icore.domain;

import ix.util.*;
import ix.util.context.*;

public class TimeWindow implements java.io.Serializable {

    protected Duration min;
    protected Duration max;

    public TimeWindow() { }

    public TimeWindow(Duration min, Duration max) {
	this.min = min;
	this.max = max;
	if (!(max == null || min.compareTo(max) <= 0))
	    throw new ConsistencyException
		("Min duration " + min + " is not <= max duration " + max);
		
    }

    public Duration getMin() {
	return min;
    }

    public void setMin(Duration d) {
	this.min = d;
    }

    public Duration getMax() {
	return max;
    }

    public void setMax(Duration d) {
	this.max = d;
    }

    public boolean hasUnboundedMax() {
	return max == null;
    }

    public String toString() {
	return "TimeWindow["
	    +     getMin().toISOString()
	    +     ".."
	    +     (hasUnboundedMax() ? "inf" : getMax().toISOString())
	    +  "]";
    }

}
