/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Sep 26 17:26:51 2002 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.icore;

import java.awt.Color;
import java.util.*;
import ix.util.*;

/**
 * Status values for "completable" entities.  This turns out to include
 * activities, issues, and process products.
 */
public final class Status extends EnumeratedValue {

    private static List values = new LinkedList();

    private Color color;

    private Status() { }

    private Status(String name, int colorRGB) {
	this.name = name;
	this.color = new Color(colorRGB);
	recordValue(values, this);
    }	

    public static final Status
	BLANK      = new Status("blank",      0xFFFFFF), // white
	COMPLETE   = new Status("complete",   0x66DDEE), // blue
	EXECUTING  = new Status("executing",  0x99FF99), // green
	POSSIBLE   = new Status("possible",   0xFFCC66), // orange
	IMPOSSIBLE = new Status("impossible", 0xFF6699), // red
	NA         = new Status("n/a",        0xCCCCCC); // light gray

    // The COMPLETE blue used to be 0x99FFFF, but looked too much
    // like the highlight colour used on (some?) Macs and was difficult
    // for a colourblind user to distinguish from the green.

    public Color getColor() {
	return color;
    }

    public String toString() {
	return name;
    }

    public static List values() {
	return Collections.unmodifiableList(values);
    }

    public static Status valueOf(String name) {
	return (Status)getValueElseError(values, name);
    }

}


