/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon May 19 01:32:02 2003 by Jeff Dalton
 * Copyright: (c) 2001 - 2002, AIAI, University of Edinburgh
 */

package ix.icore;

import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;

import ix.util.*;
import ix.util.lisp.*;
import ix.util.match.MatchEnv;

/**
 * An Issue.
 */

public class Issue extends TaskItem {

    public Issue() { }	// for XML translator /\/

    public Issue(String text) {
	this(PatternParser.parse(text));
    }

    public Issue(LList pattern) {
	super(pattern);
    }

    public Name generateId() {
	return Gensym.nextName("issue");
    }

    public Issue instantiate(MatchEnv env, Function1 ifUnbound) {
	try {
	    Issue issue = (Issue)clone();
	    issue.pattern =
		(LList)env.instantiateTree(issue.pattern, ifUnbound);
	    return issue;
	}
	catch (CloneNotSupportedException e) {
	    Debug.noteException(e);
	    throw new Error("Can't clone issue");
	}
    }

    public String toString() {
	return "Issue[id=" + id  + " " + PatternParser.unparse(pattern)
	    + "]";
    }

}
