/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Dec  5 06:57:38 2005 by Jeff Dalton
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 */

package ix.icore;

/**
 * An object that installs extensions and other modifications to
 * an IXAgent.
 *
 * <p>A class that implements this interface must have a public
 * 1-argument constructor that declares its parameter as IXAgent
 * or an IXAgent subclass.  An extension is installed by constructing
 * an instance of the class, passing an IXAgent as its parameter,
 * and then calling the instance's {@link #installExtension()}
 * method.</p>
 *
 * <p>Example:
 * <pre>
 *     public class SomeIp2Extension implements IXAgentExtension {
 *
 *         private Ip2 agent;  // Ip2 is a subclass of IXAgent
 *
 *         public SomeIp2Extension(Ip2 agent) {
 *             this.agent = agent;
 *         }
 *
 *         public void installExtension() {
 *             ...
 *         }
 *
 *     }
 * </pre></p>
 */
public interface IXAgentExtension {

    public void installExtension();

}
