/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun May  2 18:48:48 2004 by Jeff Dalton
 * Copyright: (c) 2001 - 2002, AIAI, University of Edinburgh
 */

package ix.icore;

import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;

import ix.util.*;
import ix.util.lisp.*;

/**
 * An Activity.
 */

public class Activity extends TaskItem {

    public Activity() { }	// for XML translator /\/

    public Activity(String text) {
	this(PatternParser.parse(text));
    }

    public Activity(LList pattern) {
	super(pattern);
    }

    public Name generateId() {
	return Gensym.nextName("activity");
    }

    public String toString() {
	return "Activity[" +
	    (id == null ? "" : "id=" + id  + " ") +
	    PatternParser.unparse(pattern) +
	    "]";
    }

}
