/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Mar 19 20:20:22 2005 by Jeff Dalton
 * Copyright: (c) 2000, 2005, AIAI, University of Edinburgh
 */

package ix.examples;

import java.util.*;

import ix.util.*;
import ix.util.lisp.*;


/**
 * A simple example using an I-X framework.  It shows how to define
 * activity handlers, create an IX_System that uses those handlers,
 * and tell the system of "events" that become Activities.
 *
 * It also shows how to access PicoIX in a class that isn't a
 * subclass of PicoIX.
 */

public class PicoIXTest1 {

    static class PIX extends PicoIX { 	// just to have a shorter name
    }

    /**
     * Main program.
     */
    public static void main(String[] argv) {

	PIX.IX_System example = new PIX.IX_System();

	example.addActivityHandlers(makeTestActivityHandlers());
	example.setListener(new PIX.IX_SystemListener());
	example.start();

	example.newEvent
	    (new PIX.Activity("twice", new PIX.Activity("return", "hello")));

	example.newEvent
	    (new PIX.Activity("stop when finished"));

    }

    /**
     * Create activity handlers as "instant" subclasses of ActivityHandler.
     */
    static Object[] makeTestActivityHandlers() {
	return new Object[] {

	    // Post an activity twice.
	    new PIX.ActivityHandler("twice") {
		void handleActivity(PIX.Activity i) {
		    postActivity((PIX.Activity)i.object);
		    postActivity((PIX.Activity)i.object);
		}
	    },

            // Send something to the listener.
	    new PIX.ActivityHandler("return") {
		void handleActivity(PIX.Activity i) {
		    system.notifyListener(i.object);
		}
	    },

	    // Stop the system.
	    new PIX.ActivityHandler("stop when finished") {
		void handleActivity(PIX.Activity i) {
		    if (system.controller.activities.isEmpty())
			system.stop();
		    else
			postActivity(i); 	// go to the end of the queue
		}
	    }
	};
    }

}
