/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Aug 23 14:48:24 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.applet;

import java.io.*;
import java.util.*;

import ix.util.*;
import ix.util.ipc.*;
import ix.util.xml.*;

public class CGIServerStatus extends CGIRelay {

    public CGIServerStatus() {
    }

    public static void main(String[] argv) {
	Debug.off();
	Parameters.processCommandLineArguments(argv);
	// XML.SAXDriverClass = "gnu.xml.aelfred2.SAXDriver";
	try {
	    new CGIServerStatus().handleRequest();
	}
	catch (Throwable t) {
	    Debug.noteException(t);
	    System.exit(1);
	}
	System.exit(0);
    }

    void handleRequest() throws Exception {
	AppletMessage message = new AppletMessage();
	message.setCommand("server-status");
	message.setRemoteHost(System.getProperty("cgi.remote_host"));
	message.setRemoteAddr(System.getProperty("cgi.remote_addr"));

	// See what the message server thinks of the request.
	String reply;
	try {
	    String asXML = askMessageServer(message);
	    Object obj = XML.objectFromXML(asXML);
	    if (obj instanceof String)
		reply = (String)obj;
	    else
		reply = asXML;	// ??? /\/ ???
	}
	catch (Exception e) {
	    reply = "Exception: " + Debug.describeException(e);
	}

	// Return the message server's reply.
	try {
	    printReply(reply);
	    sendStatusToMessageServer("ok");
	}
	catch (Exception e) {
	    sendStatusToMessageServer
		("Exception: " + Debug.describeException(e));
	    throw e;
	}
    }

}
