/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Aug 23 14:48:43 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.applet;

import java.io.Serializable;
import java.util.Date;

import ix.util.*;
import ix.util.lisp.*;

/**
 * Wrapper for messages between applets.
 *
 * @see AppletCommunicationStrategy
 */
public class AppletMessage implements Serializable {

    String from;
    String command;
    LList args;

    Date sendDate;		// typically only when command is send-to
    Integer sequenceNumber;	// Integer, rather than int, so it can be null

    String remoteHost;
    String remoteAddr;

    public AppletMessage() {	// needed for XML translator etc
    }

    public AppletMessage(String from, String command) {
	this(from, command, Lisp.list());
    }

    public AppletMessage(String from, String command, Object arg1) {
	this(from, command, Lisp.list(arg1));
    }

    public AppletMessage(String from, String command, 
			 Object arg1, Object arg2) {
	this(from, command, Lisp.list(arg1, arg2));
    }

    public AppletMessage(String from, String command, LList args) {
	this.from = from;
	this.command = command;
	this.args = args;
    }

    public String getFrom() {
	return from;
    }
    public void setFrom(String from) {
	this.from = from;
    }

    public String getCommand() {
	return command;
    }
    public void setCommand(String command) {
	this.command = command;
    }

    public LList getArgs() {
	return args;
    }
    public Object getArg(int i) {
	return args.get(i);
    }
    public void setArgs(LList args) {
	this.args = args;
    }

    public Date getSendDate() {
	return sendDate;
    }
    public void setSendDate(Date sendDate) {
	this.sendDate = sendDate;
    }

    public Integer getSequenceNumber() {
	return sequenceNumber;
    }
    public void setSequenceNumber(Integer s) {
	this.sequenceNumber = s;
    }
    public int getSeqNo() {
	return sequenceNumber.intValue();
    }
    public void setSeqNo(int i) {
	this.sequenceNumber = new Integer(i);
    }

    public String getRemoteHost() {
	return remoteHost;
    }
    public void setRemoteHost(String remoteHost) {
	this.remoteHost = remoteHost;
    }

    public String getRemoteAddr() {
	return remoteAddr;
    }
    public void setRemoteAddr(String remoteAddr) {
	this.remoteAddr = remoteAddr;
    }

    public LList toList() {	// for debugging
	return Lisp.list(from, command, args, remoteHost, remoteAddr);
    }

}
