/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu May 13 13:21:31 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.util.owls;

import java.io.*;
import java.net.URL;
import java.util.*;

import ix.util.*;
import ix.util.xml.*;
import ix.util.lisp.*;

/**
 * Translates an I-X Plan to an OWL-S service description
 */
public class OwlSTranslator implements Loader, Saver {

    public OwlSTranslator() {
    }

    public Object readObject(URL url) {
	// For the Loader interface.
	// We can read only Domains.
	ServiceTranslator st = new ServiceTranslator();
	return st.readServiceDomain(url.toString());
    }

    public void writeObject(Object obj, File file) throws IOException {
	// For the Saver interface.
	throw new UnsupportedOperationException
	    ("Can't yet write OWL-S in this case.");
    }

}
