/****************************************************************************
 * A renderer for items that represent priorities.
 *
 * @author Jussi Stader
 * @version 1.0
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.iview.util;

import java.util.*;
import javax.swing.Icon;
import javax.swing.ImageIcon;

import ix.icore.Priority;
import ix.iface.ui.*;
import ix.util.*;

/**
 * A renderer for items that represent priorities; uses colour and text.
 * "Normal" is initially selected.
 *
 * @see ix.icore.Priority
 */
public class PriorityRenderer extends IXLabelRenderer {

  private static final ImageIcon editableIcon = 
    Util.resourceImageIcon("ix-symbol-editable.gif");
  private static final ImageIcon disabledIcon = 
    Util.resourceImageIcon("ix-symbol-editable-disabled.gif");

  public PriorityRenderer(boolean isBordered) {super(isBordered);}
    
  public void setInfo(Object object) {
    if (object == null) {
      Debug.noteln("PriorityRenderer: cannot render null values!");
      return;
    }
    if (Priority.class.isInstance(object)) {
      Priority p = (Priority) object;
      //---colour
      this.setBackground(p.getColor());
      //--- string
      this.setText(Strings.capitalize(p.toString()));
    }
    else if (EditablePriority.class.isInstance(object)) {
      EditablePriority ep = (EditablePriority) object;
      Priority p = ep.priority;
      //---colour
      this.setBackground(p.getColor());
      //--- string
      this.setText(Strings.capitalize(p.toString()));
      //--- icon
      ImageIcon eIcon;
      if (ep.editable)  eIcon = editableIcon;
      else eIcon = disabledIcon;
      this.setIcon(eIcon);
    }
    
    else {
      Debug.noteln("PriorityRenderer got object of class", 
		     object.getClass().getName());
      Debug.noteln("Using toString to set text");
      this.setText(object.toString());
    }
  }
}

