/****************************************************************************
 * A renderer for items that represent priorities.
 *
 * @author Jussi Stader
 * @version 1.0
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.iview.util;

import java.util.*;
import javax.swing.ImageIcon;

import ix.icore.Priority;
import ix.iface.ui.*;
import ix.util.*;

/**
 * A renderer for editable items that represent priorities; uses colour and
 * text.
 * "Normal" is initially selected.
 *
 * @see ix.icore.Priority
 */
public class EditablePriorityRenderer extends IXLabelRenderer {
  private static final ImageIcon editableIcon = 
     Util.resourceImageIcon("ix-symbol-editable.gif");

    public EditablePriorityRenderer(boolean isBordered) {super(isBordered);}
    
    public void setInfo(Object object) {
      if (object == null) {
	Debug.noteln("PriorityRenderer: cannot render null values!");
	return;
      }
      if (!Priority.class.isInstance(object)) {
	Debug.noteln("PriorityRenderer got object of class", 
		     object.getClass().getName());
	Debug.noteln("Using toString to set text");
	this.setText(object.toString());
      }
      else {
	Priority p = (Priority) object;
	//---colour
	this.setBackground(p.getColor());
	//--- string
	this.setText(Strings.capitalize(p.toString()));
	//---little down-triangle to show it is editable
	this.setIcon(editableIcon);
      }
    }
  }

