/****************************************************************************
 * A TreeTableModel that can display Refinement and Node objects.
 *
 * @author Jussi Stader
 * @version 2.0
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview.table;

import ix.util.*;
import ix.util.lisp.*;
import ix.icore.domain.*;
import ix.icore.domain.event.*;
import ix.icore.*;
import ix.iview.domain.*;
import ix.iview.domain.event.*;
import ix.iface.ui.FourField;
import ix.iface.ui.table.*;
import ix.iface.ui.util.*;

import javax.swing.table.*;
import javax.swing.tree.*;
import java.util.*;


/****************************************************************************
 * A TreeTableModel that can display Refinement and Node objects.
 *****************************************************************************
 */
public class ShortActionTreeTableModel extends ActionTreeTableModel
{
  public ShortActionTreeTableModel(UIDomain uiDomain) { 
    super(false, uiDomain); //not markable
  }

  /**
   * Gets the cell value for normal cells (only one - the pattern).
   * The name cell is done in the AbstractTreeTableModel method getTreeValueAt.
   * @return the value as an object, null for illegal columns.
   */
  public Object getCellValueAt(Object o, int columnIndex) {
    return null;
  }

  /**
   * Gets the name string for the given row object.
   */
  public String getNameString(TreeNode node) {
    //Debug.noteln("***SATTM: working in model", this + " ***: " + 
    //		 ixTTNListToString(nodes));
    IXTNTreeTableNode iNode = (IXTNTreeTableNode)node;
    LList pattern = getPattern(iNode);
    //String nameString = ((Named)iNode.node).getName() + "(" + 
    //  UIUtil.listToDisplay(pattern) + ")";
    String nameString = ((Named)iNode.node).getName() + " " + 
      pattern.toString();
    return nameString;
  }
  /**
   * Gets the strings that are to be used as column names.
   */
  void setColumnNames() {
    //Debug.noteln("SATTM: setting column names");
    Class[] classes = {FourField.class, String.class};
    String[] names = {"Name(pattern)"};
    super.setColumnClasses(classes);
    super.setColumnNames(names);
  }

}
