/****************************************************************************
 * A Mouse Adapter for construct summary tables
 *
 * @author Jussi Stader
 * @version 2.3+
 * Updated: Mon Sep 11 11:01:28 2006
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
//***Not currently used

package ix.iview.table;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.*;
import javax.swing.table.*;
import javax.swing.tree.*;

import ix.*;
import ix.util.Debug;
import ix.iface.ui.*;
import ix.iface.ui.table.*;
import ix.iface.ui.util.*;
import ix.iview.*;
import ix.iview.domain.*;
import ix.iview.domain.event.*;
import ix.iview.table.*;

/**
 * A Mouse Adapter for construct summary tables
 */
//***Not currently used
public class ConstructTableMouser extends MouseAdapter {
  
  private IXTable table;
  private AConstructFramePanel panel;

  /**
   * A Mouse Adapter for construct summary tables. Works for tables
   * with AbstractIXTableModels.
   *
   */
  public ConstructTableMouser(IXTable table, AConstructFramePanel editPanel) {
    super();
    this.table = table;
    table.addMouseListener(this);
    panel = editPanel;
  }
  /**
   * If the left button was clicked on a row (except column 0) put the
   * construct in the editor.
   */
  public void mouseClicked(MouseEvent me) {
    //these clicks do not need the row to be selected - work on where clicked
    int column = table.columnAtPoint(me.getPoint());
    //only has one column so others don't make sense
    if (column == 0) return;
    
    //if ((column == 0) || !SwingUtilities.isLeftMouseButton(me)) return;
    
    int row = table.rowAtPoint(me.getPoint());
      
    if ((row >= 0) && (row < table.getRowCount())) {
      AbstractIXTableModel model = (AbstractIXTableModel)table.getModel();
      Object construct = model.getRowObject(row);
      if (construct != null) {
	if (SwingUtilities.isLeftMouseButton(me)
	    && !(construct instanceof UINodeSpec)) { //confuses users
	  //left click so edit what has been clicked on
	  panel.editConstruct(construct);
	}
	//right click, works for node specs only 
	else if (SwingUtilities.isRightMouseButton(me)
		 && (construct instanceof UINodeSpec)) {
	  if (table.hasPopup()) {
	    JObjectPopup popup = (JObjectPopup)table.getPopup();
	    panel.populatePopup(popup, construct);
	    popup.show(me.getComponent(), me.getX(), me.getY());
	  }
	}
      }
    }
  }
}
