/****************************************************************************
 * Tree table for displaying agenda items (actions and issues)
 * 
 * @author Jussi Stader
 * @version 1.0
 ****************************************************************************
 */
package ix.iview.table;


import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

import ix.icore.*;
import ix.iface.ui.*;
import ix.iface.ui.table.*;
import ix.iview.util.*;
import ix.util.*;

/****************************************************************************
 * Tree table for displaying agenda items (actions and issues)
 *
 ****************************************************************************
 */

public class AgendaTreeTable extends IXTreeTable {

  public AgendaTreeTable(){
    //    Insets ins = getInsets();
    //    setSize(ins.left + ins.right + 430,ins.top + ins.bottom + 270);
    super();
    setupAgendaTable();      
  }

  /** 
   * Makes a table and sets the given model, adjusts column widths, registers
   * model as mouse listener (if appropriate).
   */
  public AgendaTreeTable(AbstractTreeTableModel model) {
    super(model);
    setupAgendaTable();
  }

  private void setupAgendaTable() {
    setAgendaRenderersNEditors();
    setCellSelectionEnabled(true);
  }
      

  private void setAgendaRenderersNEditors() {
    EditablePriorityRenderer pr = new EditablePriorityRenderer(false);
    pr.setToolTipText("Click for choices");
    setDefaultRenderer(Priority.class, pr);
    JComboBox comboBox = new PriorityComboBox();
    setDefaultEditor(Priority.class, new DefaultCellEditor(comboBox));
  }


}
