/* Author: Jussi Stader
 * Version: 2.0
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.iview.domain;

import java.util.*;
import javax.swing.tree.*;


import ix.util.*;
import ix.util.lisp.*;
import ix.icore.domain.*;

/**
 * A class to distinguish different types of specifications that can come 
 * back from a SpecEditor.
 */
public class UISpec {
  protected String type;
  protected LList spec;

  public UISpec(String type, String spec) {
    this(type, Lisp.elementsFromString(spec));
  }
  public UISpec(String type, LList spec) {
    super();
    this.type = type;
    this.spec = spec;
  }

  public String getType() { return type;}
  public LList getSpec() { return spec;}
  public Object clone() throws CloneNotSupportedException {
    return new UISpec(type, spec);
  }

}

// Issues:


