/****************************************************************************
 * Support for editing sets of named objects (e.g. refinements or
 * object classes)
 *
 * File: AbstractUISetEditor.java
 * @author Jussi Stader
 * @version 4.3
 * Updated: Thu Oct 12 11:06:25 2006
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.iview;

import java.util.*;
import java.lang.reflect.Field;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.JOptionPane;
import javax.swing.JFileChooser;
import java.io.*;

import ix.iview.*;
import ix.iview.util.*;
import ix.iview.event.*;
import ix.iview.domain.*;
import ix.iview.domain.event.*;
import ix.icore.domain.event.*;
import ix.icore.*;
import ix.icore.domain.*;
import ix.iface.domain.*;
import ix.iface.ui.*;
import ix.iface.ui.util.*;
import ix.iface.ui.event.*;
import ix.util.*;
import ix.util.match.*;
import ix.util.lisp.*;

/**
 * Support for editing sets of named objects (e.g. refinements or
 * object classes).  Looks after adding/removing/editing the objects
 * and keeping the set consistent. Handles overwrites, finding objects
 * in the set, working out whether the set has changed.
 */

public class UIObjectClassSetEditor extends AbstractUISetEditor
{ 

  public UIObjectClassSetEditor(DomainObjectManager om, LinkedList os) {
    super(om, os);
    label = "object class"; // set for messages
    //Debug.noteln("**************Made UIObjectClassSetEditor*************");
  }

  /**
   * Crates UI versions for all objects, then enters parent/child relations.
   * Overwritten because lazy UI object making is not on with parent/child.
   */
  public void setObjects(LinkedList os) {
    //Debug.noteln("OCSetEdit got objects:", UIUtil.show(os));
    //move all current objects into removed,
    //get all relevant objects in their order and note them in nodes
    //remember they have been added.
    //Debug.noteln("OCSetEd before setting:", UIUtil.show(getAllConstructs()));
    List constructs = getAllConstructs();
    clear();
    removed.addAll(constructs);

    if (os == null) return;
    for (Iterator i = os.iterator(); i.hasNext(); ) {
      Named o = (Named)i.next();
      //Debug.noteln(" making object", o.getName());
      if (!isOwnObject(o)) { //not already made, so make it and note it
	UIObject uio = (UIObject)makeOwnObject(o);
	//members.put(o.getName(), uio); 
	addConstruct(uio);
	originals.put(o, uio);
      }
      else {
	  addConstruct((UIObject)o);
      }
    }
    //Debug.noteln(" domain originals are", UIUtil.show(getDomainOriginals()));
    //now go through Objects again and establish relations in UIOs
    for (Iterator i = os.iterator(); i.hasNext(); ) {
      Named o = (Named)i.next();
      UIObjectClass uio = (UIObjectClass)members.get(o.getName()); 
      uio.updateSuperClasses(); //addChild in parent
      //fireConstructEdited(uio);//will update super classes too!
    }
    //now forget they were "added"!
    added.clear();
    //Debug.noteln("OCSetEd objects set:", UIUtil.show(getAllConstructs()));
  }
  

  public void setLegalName(Object object, String name) {
    try {
      ((UIObjectClass)object).setLegalName(name);
    }
    catch (Exception e) {}
  }

  public boolean isOwnObject(Object object) {
    return (object instanceof UIObjectClass);
  } 
  public boolean sameConstruct(Object r, Object rOther) {
    if ((r instanceof ObjectClass) && (rOther instanceof ObjectClass)) {
      ObjectClass one = (ObjectClass)r;
      ObjectClass other = (ObjectClass)rOther;
      return (one.getName().equals(other.getName())
	      && one.getObjectProperties().equals(other.getObjectProperties())
	      && one.getSuperClassNames().equals(other.getSuperClassNames())
	      && one.getAnnotations().equals(other.getAnnotations()));
    }
    else return false; //***cannot compare
  }

  public LinkedList getDomainOriginals() {
    ListOfObjectClass origs = getDomain().getObjectClasses();
    LinkedListOfObjectClass originals = new LinkedListOfObjectClass();  
    if (origs != null) originals.addAll(origs);
    return originals;
  }

  
  //--------------------------Handling changes--------------------------------


  boolean doRehooks = false;

  private void handleOrphan(UIObjectClass oc) {
    List parents = oc.getParents();
    if ((parents == null) || (parents.size() == 0)) {
      Debug.noteln(" ****ClassSetEd:found orphan, cannot deal with this yet:", 
		   oc);
    }
  }


  public void removeConstruct(Named object) {
    UIObjectClass oc = (UIObjectClass)object;
    List children = oc.getChildren();
    List parents = oc.getParents();
    Symbol name = Symbol.intern(object.getName());

    //remove this from childrens' parents; deal with orphans
    if (children != null)
      for (Iterator i = children.iterator(); i.hasNext(); ) {
	UIObjectClass child  = (UIObjectClass)i.next();
	if (child != null) {
	  child.removeParent(name);
	  //add all parents to child
	  if (doRehooks) child.addParents(parents);
	  handleOrphan(child);
	}
      }
    //remove this from parents' children
    if (parents != null)
      for (Iterator i = parents.iterator(); i.hasNext(); ) {
	UIObjectClass parent  = (UIObjectClass)i.next();
	if (parent != null) {
	  parent.removeChild(name);
	  //add all children to parent
	  if (doRehooks) parent.addChildren(children);
	}
      }

    super.removeConstruct(object);

  }


  public Object makeOwnObject(Object object) {
    if (object == null) return null;
    if (object instanceof ObjectClass) 
      return new UIObjectClass(((DomainObjectManager)manager).getUIDomain(), 
			       (ObjectClass)object);
    else {
      Debug.noteln("WARNING - UIOCE: cannot make own object from", object);
      return null;
    }
  }

  public LinkedList makeOriginalList() {
    return new LinkedListOfObjectClass();
  }
 
  public Named getStringOriginal(String name) {
      Named objectClass = null;
      if (getDomain() != null)
	  objectClass = getDomain().getNamedObjectClass(name); 
      return objectClass;
  }
  /**
   * Finds a objectClass whose name matches the given string.
   * @return a UIObjectClass, a ObjectClass, or null - depending on
   * which exists.  */
  public Named getNamedObject(String name) {
    Named objectClass = (Named)findOwnObject(name);
    if (objectClass == null) {
      Domain currentDomain = getDomain();
      if (currentDomain != null)
	objectClass = currentDomain.getNamedObjectClass(name);
    }
    return objectClass;

  }

  
  public void fireConstructAdded(UIObject object) {
    ((UIObjectClass)object).updateSuperClasses();
    super.fireConstructAdded(object);
  }
  public void fireConstructEdited(UIObject object) {
    super.fireConstructEdited(object);
  }
  public void fireConstructRemoved(Object object) {
    if (object instanceof UIObjectClass) {
      super.fireConstructRemoved((UIObject)object);
    }
  }


  



}


// Issues:
// * tidy up load/insert domain stuff 
// * 
// * 
