/****************************************************************************
 * A class for panel-specific search 
 *
 * @author: Jussi Stader <J.Stader@ed.ac.uk>
 * Updated: Mon Oct 30 09:46:54 2006
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview;

import javax.swing.*;       
import java.util.*;       
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import ix.util.Debug;
import ix.iview.util.IVUtil;
import ix.iface.ui.*;

/*****************************************************************************
 * A class for panel-specific search.
 * The sesrcher has a field for entering a regular expression, and a list
 * in which to display results of the search. What objects go into the
 * list depends on the panel. There are two buttons: go-to to display
 * the selected result-item in the panel, and close to close the searcher.
 *
 *****************************************************************************
 */
public class PanelSearcher extends JDialog implements ActionListener {
    //MouseListener {

  protected JTextField patternField = new JTextField();
  protected ListEditorPanel searchResults;
  protected JButton searchBut = new JButton("Search");
  protected JButton goToBut = new JButton("Edit Selection");
  protected JButton closeBut = new JButton("Close");

  /*
  //a group to define the search set
  private ButtonGroup group;
  protected JRadioButton allBut;  //All constructs
  protected JRadioButton thisBut; //panel's current
  protected JRadioButton theseBut; //These constructs (previous search)
  */

  protected JComboBox searchField;

  protected AConstructFramePanel constructPanel;

  public PanelSearcher(AConstructFramePanel panel, ListCellRenderer lcr) {
      this(panel);
      searchResults.setRenderer(lcr);
  }
  public PanelSearcher(AConstructFramePanel panel) {
    super(panel.parent, "Search", false); //not modal
    constructPanel = panel;
    String constructName = panel.getName();
    searchResults = new ListEditorPanel(this, "Results", new JList());
    //searchField = new JComboBox();

    /*
    Action search = new AbstractAction("search") {
      public void actionPerformed(ActionEvent e) {
	  //PanelSearcher.this.actionPerformed(e);
	  PanelSearcher.this.search();
      }
    };
    InputMap iMap = patternField.getInputMap(); //default: WHEN_FOCUSED
    ActionMap aMap = patternField.getActionMap();
    aMap.put("search", search);
    iMap.put(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER,0), "search");
    */

    patternField.addActionListener(this);

    searchBut.addActionListener(this);

    /*IXButPanel setButPanel = setupSetButtons();*/

    Object[] winButs = {goToBut, closeBut};
    IXButPanel winButPanel = new IXButPanel(this, BoxLayout.X_AXIS, winButs);


    //put everything into a panel
    this.setSize(405,175);

    JPanel mainPanel = new JPanel();
    mainPanel.setLayout(new GridBagLayout());

    mainPanel.setBounds(0,0,500,300);

    getContentPane().add(mainPanel);

    GridBagConstraints gbc;
    int y = 0;
    JLabel label = new JLabel("Search names");
    gbc = new GridBagConstraints(0,y, 1,1, //x,y, w,h  left
				 0.0,0.0,  //weight x,y
				 GridBagConstraints.NORTHWEST, //anchor
				 GridBagConstraints.NONE,  //fill
				 new Insets(0,4,0,0),0,0); //insets and padding
    mainPanel.add(label, gbc);

    gbc = new GridBagConstraints(2,y, 1,1, //x,y, w,h  right
				 0.0,0.0,  //weight x,y
				 GridBagConstraints.NORTHEAST, //anchor
				 GridBagConstraints.NONE,  //fill
				 new Insets(0,4,0,0),0,0); //insets and padding
    mainPanel.add(searchBut, gbc);

    gbc = new GridBagConstraints(1,y, 1,1, //x,y,w,h
				 1.0,0.0,  //weight x,y
				 GridBagConstraints.NORTHWEST, //anchor
				 GridBagConstraints.HORIZONTAL,  //fill
				 new Insets(0,4,0,0),0,0); //insets and padding
    mainPanel.add(patternField, gbc);

    
    /*
    y++;
    gbc = new GridBagConstraints(0,y, GridBagConstraints.REMAINDER,1, //x,y,w,h
				 0.0,0.0,  //weight x,y
				 GridBagConstraints.NORTHWEST, //anchor
				 GridBagConstraints.HORIZONTAL,  //fill
				 new Insets(0,4,0,0),0,0); //insets and padding
    mainPanel.add(setButPanel, gbc);  
    */

    y++;
    gbc = new GridBagConstraints(0,y, 
				 GridBagConstraints.REMAINDER, 3, //x,y,w,h
				 1.0,2.0,  //weight x,y
				 GridBagConstraints.WEST, //anchor
				 GridBagConstraints.BOTH,  //fill
				 new Insets(0,4,0,0),0,0); //insets and padding
    mainPanel.add(searchResults, gbc);  


    y = y+3;
    gbc = new GridBagConstraints(0,y, GridBagConstraints.REMAINDER,1, //x,y,w,h
				 1.0,0.0,  //weight x,y
				 GridBagConstraints.SOUTH, //anchor
				 GridBagConstraints.HORIZONTAL,  //fill
				 new Insets(0,4,0,0),0,0); //insets and padding
    mainPanel.add(winButPanel, gbc);  




    patternField.requestFocus();
    //if (focusComponent != null) focusComponent.requestFocusInWindow();
    this.invalidate();
    pack();


  }

  public PanelSearcher(AConstructFramePanel panel, List searchFields) {
    this(panel);

  }

  /*
  private IXButPanel setupSetButtons() {
    allBut = new JRadioButton("All "+constructName+"s", true);
    theseBut = new JRadioButton("These "+constructName+"s", false);
    thisBut = new JRadioButton("This "+constructName, false);
    allBut.setActionCommand("All");
    thisBut.setActionCommand("This");
    theseBut.setActionCommand("These");
    allBut.setToolTipText("Search all "+constructName+"s in the domain");
    thisBut.setToolTipText("Search only the current "+constructName+
			   " in the panel");
    enableSetButs();
    theseBut.
      setToolTipText("Search the list of results in this search window");
    
    Object[] setButs = {allBut, thisBut, theseBut};
    IXButPanel setButPanel = new IXButPanel(this, BoxLayout.X_AXIS, setButs);
    setButPanel.setButtonGroup(true);
    group = setButPanel.group;
    return setButPanel;
  }

  protected void enableSetButs() {
    allBut.setEnabled(true);
    thisBut.setEnabled((constructPanel.getUIConstruct() != null)
		       && !constructPanel.getUIConstruct().isEmpty());
    theseBut.setEnabled(hasResults());
  }
  */

  public boolean hasResults() {
    if (searchResults == null) return false;
    Object data = searchResults.getData();
    if (data == null) return false;
    if (data instanceof Object[]) {
      int len = ((Object[])data).length;
      if (len > 0) return true;
      else return false;
    }
    else Debug.noteln("PS:Got odd list data class", data.getClass());
    return false;
  }

  protected void search() {
    searchBut.setText("Cancel");
    //start thread to search

    String pattern = patternField.getText();
    if (pattern == "") stopSearch();
    else {
      Set matches = doSearch(pattern);
      finishSearch(matches);
    }

  }

  private Set doSearch(String pattern) {
    List constructs = constructPanel.getAllConstructs();
    Set matches = IVUtil.findNameMatches(pattern, constructs);
    return matches;
  }

  private void finishSearch(Set matches) {
    //showResults();
    searchResults.setData(matches);
    stopSearch();
  }
  protected void stopSearch() {
    //enableSetButs();
    searchBut.setText("Search");
  }


  public void close() {
    setVisible(false);
  }


  //--------------------------------Listener things

  public void actionPerformed(ActionEvent e){
    //Debug.noteln("PS: processing action from", e.getSource());
    //Debug.noteln("  command is", e.getActionCommand());
    //Debug.noteln("  event is", e);
    if (e.getSource() == this.closeBut) {
      this.close();
      return;
    }
    else if (e.getSource() == this.goToBut) {
	//get the current selection
	Object selection = searchResults.getSelectedObject();
	//get editor panel to edit it
	if (selection == null)
	  JOptionPane.showMessageDialog(null, 
					"No result selected - nothing done");
    }
    if ((e.getSource() == patternField) || (e.getSource() == this.searchBut)) {
      search();
    }
  }

}
