/****************************************************************************
 * A simple node number renderer for list or table cells.
 *
 * @author Jussi Stader
 * @version 2.0
 * Updated: Thu May 11 10:13:33 2006
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;

import ix.util.Name;
import ix.util.lisp.LList;
import ix.iface.ui.*;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Named;
import ix.iview.domain.UIRefinement;

/****************************************************************************
 * A simple node number renderer for list or table cells.
 *
 *****************************************************************************
 */
class NodeNumberRenderer extends IXLabelRenderer {//IXTextRenderer
  /** 
   * Creates a node number renderer with/without a border.
   * @param isBordered - flag that determines whether to put a border around
   * the cell to show selection status
   */
  public NodeNumberRenderer(boolean isBordered) {super(isBordered);}
  /**
   * Sets the cell text to the node number.
   */
  public void setInfo(Object object){
    if (object == null) setText("");
    else {
      String text = "??";
      if (object instanceof LList) 
	text = (((LList)object).elementAt(0).toString());
      else if (object instanceof NodeSpec) 
	text = ((NodeSpec)object).getId().toString();
      else if (object instanceof UIRefinement) 
	text = "self (" + ((Named)object).getName() + ")";
      setText(text);
    }
  }
}
