/****************************************************************************
 * A simple panel with a label, a text component, and optional buttons.
 *
 * @author Jussi Stader
 * @version 2.0
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview;

import javax.swing.*;
import java.awt.event.*;

import ix.util.Debug;
import ix.icore.domain.*;
import ix.iface.ui.*;
import ix.iview.domain.*;
    
/**
 * A simple panel with a label (title), a component, and optional buttons.
 * The given label will be at the top, the given component at the left and
 * buttons with given labels on the right.
 * Adds the given listener to the buttons and the list.
 */
public class MiniConstraintPanel extends AbstractEditorPanel 
implements SchemaTerms {
  public final static AbstractButton sequenceB = 
           new JRadioButton(O_SEQUENCE);
  public final static AbstractButton parallelB = 
           new JRadioButton(O_PARALLEL);
  public final static AbstractButton otherB = 
           new JRadioButton(O_OTHER);
  private ButtonGroup group;
  public AbstractButton defaultB = sequenceB;
  public AbstractButton LastB = defaultB;

  public MiniConstraintPanel(MouseListener ml, String label, 
			     String[] buttons) {
    super(ml, label, buttons);
    sequenceB.setActionCommand(O_SEQUENCE);
    parallelB.setActionCommand(O_PARALLEL);
    otherB.setActionCommand(O_OTHER);
    Object[] orderButs = {sequenceB, parallelB, otherB};
    
    IXButPanel groupPanel = new IXButPanel(ml, BoxLayout.X_AXIS, orderButs);
    groupPanel.setButtonGroup(true);
    group = groupPanel.group;
    super.makePanelComponent(ml, groupPanel);
  }

  public boolean isListItem() { return false;}

  /**
   * Gets the current data of a text component. Buttons are made via IXButPanel
   * which always adds an action command (using the label if necessary).
   * @return data a string that contains the text from component.
   */
  public Object getData() {
    ButtonModel bm = group.getSelection();
    String command = bm.getActionCommand();
    return command;
  }

  /**
   * Sets the current data of a text component.
   * @param data a string that contains the text to put into the component
   */
  public void setData(Object data) {
    parallelB.setEnabled(true);
    sequenceB.setEnabled(true);
    otherB.setEnabled(false);
    if (O_NONE.equals(data)) LastB.setSelected(true);
    else if (O_PARALLEL.equals(data)) parallelB.setSelected(true);
    else if (O_SEQUENCE.equals(data)) sequenceB.setSelected(true);
    else {
      otherB.setEnabled(true);
      otherB.setSelected(true);
    }
  }

  public void setDefaultSelection(Object data) {
    if (O_PARALLEL.equals(data)) defaultB = parallelB;
    else if (O_SEQUENCE.equals(data)) defaultB = sequenceB;   
    else Debug.noteln("Cannot set the default button to " + data.toString());
  }

  /**
   * Removes all text from the component.
   */
  public void removeData() {
    //Debug.noteln("MiniCP: removing data");
    defaultB.setSelected(true);
    otherB.setEnabled(false);
  }

  public void setLast(AbstractButton button) {
    LastB = button;
  }
  public AbstractButton getLast() {
    return LastB;
  }

  

  public boolean setRenderer(ListCellRenderer r) {return false;}

}
