/****************************************************************************
 * An interface model to be used to fill an IFormPanel.
 *
 * @author Jussi Stader
 * @version 2.0
 * Updated: Sun Aug  1 15:58:43 2004 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview;

import ix.*;
import ix.util.Debug;
import ix.util.lisp.*;
import ix.iface.ui.util.*;
import ix.iface.ui.AbstractIFormModel; // added by jd for ix-3.3 /\/
import ix.icore.info.*;

import java.util.*;
import java.lang.reflect.*;
//import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * An default model to be used to fill an IFormPanel.
 *
 */
public class InfoIFormModel extends AbstractIFormModel {

  public InfoIFormModel(AbstractIObject object) {
    super(object);
  }

  
  public void setFields() {
    String[] names = {"name"};
    setNameFields(names);
    // /\/: The next line would not compile.
    // List dFields = new ArrayList((AbstractIObject)baseObject.getAttributes());
    // It looks like it was meant to be:
    List dFields = new ArrayList(((AbstractIObject)baseObject)
				 .getAttributes());
    // JD for ix-3.3
    setDisplayFields(dFields);
  }

  public void setGenericFields() {
    if (baseObjectClass == null) {
      Debug.noteln("Cannot set fields for a null base object class.");
      return;
    }
    else {
      nameFields = this.deriveNameFields();
      displayFields = this.deriveDisplayFields();
      List allFields = new LListCollector(nameFields);
      allFields.addAll(displayFields);
      deriveNames(allFields);
      deriveClasses(allFields);
    }
  }

  protected void deriveNames(List fields) {
    fieldNames.clear();
    if (fields.isEmpty()) return;
    else {
      for (Iterator i = fields.iterator(); i.hasNext(); ) {
	String field = (String)i.next();
	fieldNames.put(field, deriveName(field));
      }
    }       
  }
  protected String deriveName(String field) {
    return UIUtil.toCapitalised(field);
  }


  protected void deriveClasses(List fields) {
    fieldClasses.clear();
    if (fields.isEmpty()) return;
    else {
      for (Iterator i = fields.iterator(); i.hasNext(); ) {
	String field = (String)i.next();
        Class type = deriveClass(field);
	fieldClasses.put(field, type);
      }
    }       
  }
  protected Class deriveClass(String field) {
    try {
      Field oField = stringToField(field);
      return oField.getType();
    }
    catch (Exception e) {
      Debug.note("Working on class " + getObjectClass().getName());
      Debug.noteln("Fields are: " + 
		   UIUtil.fieldsToNames(getObjectClass().getFields()));
      Debug.noteln(" Problem deriving class for field " + field);
      Debug.noteException(e);
      return null;
    }
  }


  protected List deriveNameFields() {
    //get the class to work with
    Class c = this.getObjectClass();
    if (c == null) {
      Debug.noteln("FormModel: base object class not known.");
      return null;
    }
    //get name fields
    List fields = new LListCollector();
    fields = (List)addIfField(fields, c, "name");
    fields = (List)addIfField(fields, c, "Name");
    if (fields.isEmpty()) {
      //get all class fields and search for sub-string name
      Field[] cFields = c.getFields();
      String fName;
      for (int i = 0; i<cFields.length; i++) {
	fName = cFields[i].getName().toUpperCase();
	if (fName.indexOf("NAME") != -1)
	  fields.add(cFields[i].getName());	
      }
    }
    fields = (List)addIfField(fields, c, "id");
    fields = (List)addIfField(fields, c, "Id");
    fields = (List)addIfField(fields, c, "ID");
    return fields;
  }

  protected List deriveDisplayFields() {
    //get the class to work with
    Class c = this.getObjectClass();
    if (c == null) {
      Debug.noteln("FormModel: base object class not known.");
      return null;
    }
    //get fields
    List fields = new LListCollector(Arrays.asList(c.getFields()));
    List dFields = new LListCollector();
    for (Iterator i = fields.iterator(); i.hasNext(); ) {
      Field field = (Field)i.next();
      if (useField(field)) 
	dFields.add(field.getName());
    }
    return dFields;
  }

  protected boolean useField(Field field) {
    int mod = field.getModifiers();
    //do not display protected, private, static, or name fields
    return (!Modifier.isStatic(mod) && 
	    !Modifier.isPrivate(mod) &&
	    !Modifier.isProtected(mod) && 
	    !nameFields.contains(field.getName()));
  }

}
