/****************************************************************************
 * Static symbols for I-DE
 *
 * @author Jussi Stader
 * @version 1.0
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview;

import ix.util.lisp.*;


/****************************************************************************
 * Static symbols for I-DE
 *****************************************************************************
 */
public interface IDESymbols {

  //Modes for preferences - simple: restricted to minimal/single/...
  //advanced: full range of preferences
  public static final Symbol MODE_SIMPLE = Symbol.intern("mode-simple"); 
  public static final Symbol MODE_ADVANCED = Symbol.intern("mode-advanced"); 

  //activity views for preferences
  public static final Symbol VIEW_MINIMAL = Symbol.intern("view-minimal"); 
  public static final Symbol VIEW_COMPREHENSIVE = 
     Symbol.intern("view-comprehensive"); 
  public static final Symbol VIEW_GRAPHICAL = Symbol.intern("view-graphical"); 

  public static final Symbol[] VIEWS = {VIEW_MINIMAL, VIEW_COMPREHENSIVE,
					VIEW_GRAPHICAL};

  //preferences that determine how constraints are shown in the editor
  public static final Symbol C_NONE = Symbol.intern("none");
  public static final Symbol C_ORDER_ONLY = Symbol.intern("order-only");
  public static final Symbol C_ORDER_OTHER = Symbol.intern("order-other");
  public static final Symbol C_ORDER_CONDITIONS = 
    Symbol.intern("order-conditions");
  public static final Symbol C_ALL = Symbol.intern("order-conditions-other");
  public static final Symbol C_CONDITIONS_ONLY = 
    Symbol.intern("conditions-only");
  public static final Symbol C_CONDITIONS_OTHER = 
    Symbol.intern("conditions-other");
  public static final Symbol C_OTHER_ONLY = Symbol.intern("other-only");


}
