/****************************************************************************
 * A Preferences dialog for IDE.
 *
 * @author Jussi Stader
 * @version 2.3+
 * Updated: Mon Sep  4 14:03:24 2006
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview;

import ix.*;
import ix.util.*;
import ix.util.lisp.*;
import ix.iface.ui.util.*;
import ix.iface.ui.*;
import ix.iview.util.*;

import java.util.*;
import java.io.*;
import java.awt.Component;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;



/****************************************************************************
 * A Preferences dialog for IDE.
 *****************************************************************************
 */
public class IDEPreferencesDialog extends JPreferencesDialog 
  implements IDESymbols, ChangeListener
{

  public IDEPreferencesDialog(DomainEditorFrame frame, 
			      JPropertiesManager manager) {
    super(frame, manager);
  }
  
  public void makeComponents() {
    /*
    /prefsPanel has flow layout, so just parcel things up and add them.
    /To parcel up: all single flags go in a column with check-boxes
    / all possible-values things go in their own parcel.
    /For each of those: make a box and stack the possible values into it
    / make a panel, add a label and the box to it.
    */

    //JPanel panel1 = new JPanel();
    //JPanel panel2 = new JPanel();
    Box column;
    //Debug.noteln("IDEPD: Making components");
    JToggleButton item;
    List components;

    column = new Box(BoxLayout.Y_AXIS);
    components = new ArrayList();
    JToggleButton modeItem = new JCheckBox("Simple mode");
    modeItem.setActionCommand(MODE_SIMPLE.toString()); 
    modeItem.
      setToolTipText("Set the mode to simple (tick) or advanced (no tick)");
    modeItem.setSelected(manager.getProperty("ideMode").
			 equals(modeItem.getActionCommand()));
    modeItem.addChangeListener(this);
    column.add(modeItem);
    components.add(modeItem);
    keyComponents.put("ideMode", components);

    components = new ArrayList();
    item = new JCheckBox("Set editable");
    item.setActionCommand("propEditable"); 
    item.setToolTipText("Switch off to use the editor as a viewer only");
    item.setSelected(manager.getProperty("ideEditable").equals("true"));
    item.setEnabled(false);
    column.add(item);
    keyComponents.put("ideEditable", components);

    components = new ArrayList();
    item = new JCheckBox("Show text on toolbar buttons");
    item.setActionCommand("showButtText"); 
    item.setToolTipText("Toggle text on toolbar buttons on/off");
    item.setSelected(manager.getProperty("ideShowButtonTexts").
		     equals("true"));
    column.add(item);
    components.add(item);
    keyComponents.put("ideShowButtonTexts", components);

    components = new ArrayList();
    item = new JCheckBox("Use object constraint editor");
    item.setActionCommand("useNewCondEd"); 
    item.setToolTipText("Use object-style condition/effect editor");
    item.setSelected(manager.getProperty("ideNewCondEditor").
		     equals("true"));
    column.add(item);
    components.add(item);
    keyComponents.put("ideNewCondEditor", components);

    components = new ArrayList();
    item = new JCheckBox("Use text fields for lists");
    item.setActionCommand("ListsAsTexts"); 
    item.setToolTipText("Edit by typing (tick) or dialogue (no tick)");
    item.setSelected(manager.getProperty("ideListsAsTexts").
		     equals("true"));
    item.setEnabled(true);
    column.add(item);
    components.add(item);
    keyComponents.put("ideListsAsTexts", components);
    prefsPanel.add(column);
    //panel1.add(column);
    

    makeRadioComponent("idePanelStyle", "Preferred Panel Style", 
		       ((DomainEditorFrame)frame).getPanelStyles(), 
		       "is the preferred style");
    makeRadioComponent("ideActivityView", "Preferred Activity View", 
		       Arrays.asList(VIEWS), "is the preferred activity view");

    String[] cViews = {"orderings", "conditions/effects", "other constraints"};
    makeCheckBoxComponent("ideConstraints", "Preferred Constraints View",
			  Arrays.asList(cViews), "should be shown");

    simpleEffect(modeItem);

  }

  public boolean setComponentFromProperty(String key, List components, 
					  String value) {
    boolean setOne = false;
    if (components == null) {
      Debug.noteln("no components for", key);
      return setOne;
    }
    if (key.equals("ideConstraints")) {
      for (Iterator i = components.iterator(); i.hasNext(); ) {
	try {  //only interested in check-boxes
	  JToggleButton c = (JToggleButton)i.next();
	  String command = c.getActionCommand();
	  if (IDEUtil.showConstraints(command, Symbol.intern(value)))
	    c.setSelected(true);
	  else c.setSelected(false);
	  setOne = true;
	} catch (Exception e) {}
      }
    }
    else 
      for (Iterator i = components.iterator(); i.hasNext(); ) {
	try {  //only interested in check-boxes
	  JToggleButton c = (JToggleButton)i.next();
	  String command = c.getActionCommand();
	  if (command.equals(value)) c.setSelected(true);
	  else c.setSelected(false);
	  setOne = true;
	} catch (ClassCastException e) {}
      }
    return setOne;
  }

  protected void setEnabledComponent(Component c, boolean able) {
      try {  //only interested in check-boxes
        ((JToggleButton)c).setEnabled(able);
      } catch (Exception e) {}
  }

  public String getPropertyFromComponent(String key, List components) {
    if (key.equals("ideMode")) {
      for (Iterator i = components.iterator(); i.hasNext(); ) {
	try {  //only interested in check-boxes
	  JToggleButton c = (JToggleButton)i.next();
	  String command = c.getActionCommand();
	  if (c.isSelected()) return MODE_SIMPLE.toString();
	  else return MODE_ADVANCED.toString();
	} catch (Exception e) {}
      }
      return manager.getProperty(key);
    }
    if (key.equals("idePanelStyle")) {
      for (Iterator i = components.iterator(); i.hasNext(); ) {
	try {  //only interested in check-boxes
	  JToggleButton c = (JToggleButton)i.next();
	  String command = c.getActionCommand();
	  if (c.isSelected()) return c.getActionCommand();
	} catch (Exception e) {}
      }
      return manager.getProperty(key);
    }
    else if (key.equals("ideActivityView")) {
      for (Iterator i = components.iterator(); i.hasNext(); ) {
	try {  //only interested in check-boxes
	  JToggleButton c = (JToggleButton)i.next();
	  String command = c.getActionCommand();
	  if (c.isSelected()) return c.getActionCommand();
	} catch (Exception e) {}
      }
      return manager.getProperty(key);
    }
    else if (key.equals("ideConstraints")) {
      boolean[] on = {true, true, true};
      int n = 0;
      try {  
	for (Iterator i = components.iterator(); i.hasNext(); n++) {
	  //only interested in check-boxes
	  JToggleButton c = (JToggleButton)i.next();
	  String command = c.getActionCommand();
	  on[n] = c.isSelected();
	} 
	return IDEUtil.makeConstPrefSymbol(on[0], on[1], on[2]).toString();
      } catch (Exception e) {
	return manager.getProperty(key);
      }
    }
    return manager.getProperty(key);
  }
  public void stateChanged(ChangeEvent e) {
    simpleEffect((JToggleButton)e.getSource());
  }

  // in simple mode, style is fixed as "single", activity view as "minimal"
  // in advanced mode they are enabled
  private void simpleEffect(JToggleButton modeItem) {
    List comps;
    if (modeItem.isSelected()) {
      comps = (List)keyComponents.get("idePanelStyle");
      //setComponentFromProperty("idePanelStyle", comps, "single");
      setEnabledComponents("idePanelStyle", comps, false);
      comps = (List)keyComponents.get("ideActivityView");
      //setComponentFromProperty("ideActivityView", comps, "minimal");
      setEnabledComponents("ideActivityView", comps, false);
      setEnabledComponents("ideConstraints", false);
    }
    else {
      setEnabledComponents("idePanelStyle", true);
      setEnabledComponents("ideActivityView", true);
      setEnabledComponents("ideConstraints", true);
    }
  }

  public void localCommandClicked(String command) {}

}
