/****************************************************************************
 * A grammar editor/viewer panel 
 *
 * @author Jussi Stader
 * @version 2.3+
 * Updated: Mon Apr  3 11:21:40 2006
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview;

import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
//import java.awt.*;
import java.awt.GridLayout;
import java.awt.event.*;

import ix.*;
import ix.util.Debug;
import ix.util.Util;
import ix.util.lisp.*;
import ix.icore.*;
import ix.icore.domain.*;
import ix.icore.domain.event.*;
import ix.iface.ui.*;
import ix.iface.ui.util.*;
import ix.iface.domain.*;
import ix.iview.*;
import ix.iview.domain.*;
import ix.iview.domain.event.*;

/****************************************************************************
 * A grammar editor/viewer panel
 *
 * Waiting to be documented and implemented properly. <p>
 * Example code for using the GrammarEditorPanel:
 *<PRE><code>
 *    AConstructFramePanel grammarPanel = new GrammarEditorPanel(ide);
 *</code></PRE>
 *****************************************************************************
 */
public class GrammarEditorPanel extends AConstructFramePanel
implements ActionListener, UIDomainListener {
  private AbstractEditorPanel issuePatternList;
  private AbstractEditorPanel nodePatternList;
  private AbstractEditorPanel constraintPatternList;

  private HashSet issuePatterns = new HashSet();
  private HashSet nodePatterns = new HashSet();
  private List constrPatterns = new ArrayList();

  private MouseListener ml = new MouseAdapter() {};

  private boolean listsAsText = true;//flag for showing lists as list or text

  public GrammarEditorPanel(DomainEditorFrame frame) {
    super(frame);
    //updatePatterns();
  }

  protected JPanel setupMainPanel() {
    //Debug.noteln("GrEP: setting up main panel");
    //scroll panes have ONE child, so use mainPanel for everything
    //mainPanel = new JPanel(new BorderLayout());
    mainPanel = new GrammarFormPanel(this);

    scrollPane.getViewport().add(mainPanel); //mainPanel
    
    listsAsText = parent.listsAsText();
    //JScrollPane jsp = new JScrollPane();
    //jsp.getViewport().add(list);
    //nodePatternList = 
    //  new ListEditorPanel(ml,"Node Patterns",jsp,buttons);
    makeLists();
    //mainPanel.add(patternList, BorderLayout.CENTER);
    return mainPanel;
  }


  public void refresh() {
    updatePatterns();
  }

  public boolean beforeSwitching() {
    return true;
  }
     

  public void setListsAsText(boolean asText) {
    if (listsAsText != asText) {
      listsAsText = asText;
      removeLists();
      makeLists();
      updatePatterns();
    }
  }

  private void makeLists() {
    issuePatternList = makeList(ml, "Issue Patterns");
    nodePatternList = makeList(ml, "Node Patterns");
    constraintPatternList = makeList(ml, "Constraint Patterns");
    //fillConstraintPatternList();
  }
  private void removeLists() {
    mainPanel.remove(issuePatternList);
    mainPanel.remove(nodePatternList);
    mainPanel.remove(constraintPatternList);
    issuePatternList.removeData();
    nodePatternList.removeData();
    constraintPatternList.removeData();
    issuePatternList = null;
    nodePatternList = null;
    constraintPatternList = null;
  }

  private AbstractEditorPanel makeList(MouseListener ml, String label) {
    //Debug.noteln("GrEP: making list. asText:", new Boolean(listsAsText));
    String[] buttons = {"Add","Delete","Clear"};
    AbstractEditorPanel lep;
    if (listsAsText) {
      JTextArea thing = new JTextArea();
      thing.setRows(5);
      lep = new ThingEditorPanel(ml, label, thing, buttons);
    }
    else {
      JList thing = new JList();
      thing.setVisibleRowCount(5);
      thing.setCellRenderer(new IXLabelRenderer(false) { //IXTextRenderer
	public void setInfo(Object object) {
	  String text = "";
	  if (object instanceof Collection)
	    text = UIUtil.listToDisplay((Collection) object);
	  else text = object.toString();
	  setText(text);
	}
      });
      lep = new ListEditorPanel(ml, label, thing, buttons);
    } 
    lep.setEnabled(false);
    mainPanel.add(lep);
    return lep;
  }

  /** This is fixed for now */
  private void fillConstraintPatternList() {
    /*
    String[] values = {"temporal  before  <node-end> <node-end>",
		       "world-state  condition  <pattern> = <value>",
		       "world-state  effect  <pattern> = <value>",
		       "<type>  <relation>  <parameters>"};
    constraintPatternList.setData(values);
    */
  }


  protected UIObject cloneConstruct(UIObject uiConstruct) {
    return null;
  }

 /** 
   * Make a new construct of the panel's type and get ready to edit it.
   */
  public void newConstruct() {
    //this.setConstruct(null);
  }
  public UIObject makeNewConstruct() {
    return null;
  }
  /** 
   * Save a construct of the panel's type into the draft domain.
   */
  public void saveConstruct() {
    UIUtil.notImplemented(this,"Saving grammars");
  }
  /** 
   * Notes the content of the editing panel into the current(new?) UIObject.
   */
  protected UIObject noteConstruct() {
    return null;
  }
  /** 
   * Put a given construct of the panel's type into the panel ready for editing
   */
  public void setConstruct(IXObject construct) {
    if (construct == null) {
      issuePatternList.removeData();
      nodePatternList.removeData();
      constraintPatternList.removeData();
    }
    else UIUtil.notImplemented(this,"Setting grammars");
  }
  /** 
   *  Check a construct of the panel's type for errors and inconsistencies
   */
  public boolean checkConstruct() {
    UIUtil.notImplemented(this,"Checking grammars");
    return true;
  }
  /** 
   * Get a full list of the constructs of the panel's type in the domain.
   */
  public List getAllConstructs() {
    return new LListCollector();
  }
  public Named getNamedConstruct(String name) {
    return null;
  }

  public void constructAdded(UIDomainEvent se) {
    updatePatterns();
  }
  public void constructAdded(DomainEvent se) {
    updatePatterns();
  }
  public void constructEdited(UIDomainEvent se) {
    updatePatterns();
  }
  public void constructRemoved(UIDomainEvent se) {
    updatePatterns();
  }
  public void domainCleared(UIDomainEvent se) {
    updatePatterns();
  }
  public void domainEdited(UIDomainEvent se) {
  }
  public void domainSet(UIDomainEvent se) {
    updatePatterns();
  }

  private void updatePatterns() {
    issuePatterns.clear();
    nodePatterns.clear();
    constrPatterns.clear();
    UIDomain dom = parent.getUIDomain();
    if (dom != null) {
      List refs = dom.getAllRefinements();
      for (Iterator i = refs.iterator(); i.hasNext(); ) 
	addAllPatterns(i.next());
      constrPatterns = new ArrayList(dom.grammar.getConstraintPatterns());
    }
    //Debug.noteln("Constraint patterns:", UIUtil.show(constrPatterns));
    updateListPatterns(issuePatternList, issuePatterns);
    updateListPatterns(nodePatternList, nodePatterns);
    updateListPatterns(constraintPatternList, constrPatterns);
    //fillConstraintPatternList();
  }

  private void addAllPatterns(Object o) {
    if (o == null) return;

    Iterator i = null;
    List rn = null;
    List ri = null;
    List rc = null;

    Object pattern = null;
    if (Refinement.class.isInstance(o)) {
      Refinement r = (Refinement)o;
      nodePatterns.add(r.getPattern());
      rn = r.getNodes();
      ri = r.getIssues();
      rc = r.getConstraints();
    }
    else if (UIRefinement.class.isInstance(o)) {
      UIRefinement r = (UIRefinement)o;
      nodePatterns.add(r.getPattern());
      rn = r.getNodes();
      ri = r.getIssues();
      rc = r.getConstraints();
    }
    else {
      Debug.noteln("GEP: Cannot get patterns from class ", 
		   o.getClass().getName());
      return;
    }

    if (rn != null)  
      nodePatterns = getNodePatterns(rn.iterator(), nodePatterns);
    if (ri != null)  
      issuePatterns = getIssuePatterns(ri.iterator(), issuePatterns);
    if (rc != null)  
      constrPatterns = 
	getConstraintPatterns(rc.iterator(), constrPatterns);
  }


  private void updateListPatterns(AbstractEditorPanel list, HashSet patterns) {
    LinkedList pList = new LinkedList(patterns);
    Collections.sort(pList, new UIUtil.ToStringComparator());
    list.setData(pList);
  }

  private void updateListPatterns(AbstractEditorPanel list, List patterns) {
    list.setData(patterns);
  }

  public HashSet getAllPatterns() {
    if (parent.getUIDomain() == null) return null;
    else {
      List refs = parent.getUIDomain().getAllRefinements();
      Iterator i = refs.iterator();
      HashSet patterns = new HashSet();
      while (i.hasNext()) 
	patterns.addAll(getAllPatterns(i.next()));
      return patterns;
    }
  }
  public HashSet getAllPatterns(Object o) {
    HashSet patterns = new HashSet();
    if (o == null) return patterns;
    Iterator i = null;
    List rn = null;
    List ri = null;

    Object pattern = null;
    if (Refinement.class.isInstance(o)) {
      Refinement r = (Refinement)o;
      rn = r.getNodes();
      if (rn != null)  patterns = getNodePatterns(rn.iterator(), patterns);
      ri = r.getIssues();
      if (ri != null)  patterns = getIssuePatterns(ri.iterator(), patterns);
      patterns.add(r.getPattern());
    }
    else if (UIRefinement.class.isInstance(o)) {
      UIRefinement r = (UIRefinement)o;
      rn = r.getNodes();
      if (rn != null)  patterns = getNodePatterns(rn.iterator(), patterns);
      ri = r.getIssues();
      if (ri != null)  patterns = getIssuePatterns(ri.iterator(), patterns);
      patterns.add(r.getPattern());
    }
    else {
      Debug.noteln("GEP: Cannot get patterns from class ", 
		   o.getClass().getName());
      return null;
    }

    return patterns;
  }

  public HashSet getNodePatterns(Iterator i, HashSet patterns) {
    if (i != null) 
      while (i.hasNext()) 
	patterns.add(((NodeSpec)i.next()).getPattern());  
    return patterns;
  }
  public HashSet getIssuePatterns(Iterator i, HashSet patterns) {
    if (i != null) 
      while (i.hasNext()) 
	patterns.add(((TaskItem)i.next()).getPattern());  
    return patterns;
  }
  public List getConstraintPatterns(Iterator i, List patterns) {
    //Debug.noteln("Cannot collect constraint patterns yet");
    return patterns;
  }


  public boolean frameActionPerformed(ActionEvent event){
    String command = event.getActionCommand();
    if (command == "newConstruct") newConstruct();
    else if (command == "editConstruct") {
      //***dummy
    }
    else if (command == "modify") saveConstruct();
    else if (command == "check") checkConstruct();
    else return false;
    return true;
  }


  /**
   * Wakes up the ActionListener with a user action.
   * This is called when a KeyStroke happens in which the ActionListener
   * registered its interest.
   */
  public void actionPerformed(ActionEvent ae){
    String command = ae.getActionCommand();
    Debug.noteln("Grammar editor: Got action command", command);
  }


  public class GrammarFormPanel extends JPanel implements ConstructEditing {

    private AConstructFramePanel parent;
    private UIObject uiConstruct;

    public GrammarFormPanel(AConstructFramePanel theParent) {
      super(new GridLayout(3, 1));
      parent = theParent;
    }

    //----------------------------Construct Editing things---------------------

    public UIDomain getUIDomain() {
      return parent.getUIDomain();
    }
    public void setConstruct(IXObject construct) {
      setUIConstruct(getUIDomain().getUIObject(construct));
    }
    public IXObject getConstruct() {
      if (uiConstruct == null) return null;
      else return uiConstruct.getBaseObject();
    }
    public void setUIConstruct(UIObject construct) {
      setUIConstructOnly(construct);
      //getModel().setObject(construct);
    }
    public void setUIConstructOnly(UIObject construct) {
      UIObject old = uiConstruct;
      uiConstruct = construct;
      //getModel().setObject(construct);
      parent.fireConstructChanged(old, construct, this);
    }
    public UIObject getUIConstruct() {
      return uiConstruct;
    }

    public void loadFromObject() {
      //displayModelData();
    }
    public void saveToObject(EditableObject eo) {
      //displayModelData();
    }

  }

}

/*Issues***************************************************************
 *
 * implement this?
 *
 */
/*Todos***************************************************************
 *
 *****************************************************************************
 */
