/****************************************************************************
 * A panel containing form-style sub-panels for viewing/editing an object
 *
 * @author Jussi Stader
 * @version 3.1
 * Updated: Thu Oct 12 12:29:18 2006
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview;

import ix.*;
import ix.util.Debug;
import ix.util.lisp.*;
import ix.iface.ui.*;
import ix.iface.ui.util.*;
import ix.iface.ui.table.*;
import ix.iview.event.*;
import ix.iview.table.*;
import ix.iview.util.*;
import ix.iview.domain.*;
import ix.iview.domain.event.*;
import ix.icore.*;
import ix.icore.domain.*;
import ix.icore.domain.event.*;

import java.util.*;
import java.lang.reflect.*;
//import java.awt.*;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;

/**
 * A panel containing form-style sub-panels for viewing/editing an object
 *
 */
public class GlobalFormPanel extends IFormPanel 
implements ConstructEditing, UIDomainListener, ListSelectionListener {

  private UIObject uiConstruct;

  private UIRefinement currentAction;
  private ActionTreeTableModel tableModel;
  public IXTreeTable table;
  private AConstructFramePanel parent;

  /** Listeners interested in the current action */
  HashSet actionListeners = new HashSet();



  public GlobalFormPanel(AConstructFramePanel theParent) {
    super();
    parent = theParent;
  }
  public GlobalFormPanel(AConstructFramePanel theParent, IFormModel m) {
    super(m);
    parent = theParent;
  }

  //----------------------------Window buidling things-----------------------

  protected void setRenderers() {
    IXRenderer r = new ActionListRenderer(false);

    fieldRenderers.put("refinements", r);
    //r = new DescriptionsRenderer(false);
    //fieldRenderers.put("annotations", r);
  }

  protected IXEditorPanel makeDisplayBit(String field) {
    //Debug.noteln("GlobalFormPanel: making display bit for " + field);
    if (field.equals("refinements")) {
      //Debug.noteln(" making refinements table");
      String[] buttons = {"Add","Edit","Delete"};
      tableModel = new ActionTreeTableModel(false, getUIDomain());
      table = new IXTreeTable(tableModel);
      tableModel.setParentsBold(true);
      table.setPreferredScrollableViewportSize(new Dimension(200, 100));
      table.getSelectionModel().addListSelectionListener(this);
      JScrollPane jsp = new JScrollPane();
      jsp.getViewport().add(table);
      return new ListEditorPanel(this,model.getFieldName(field),jsp,buttons);
    }
    else return super.makeDisplayBit(field);
  }

  //----------------------------Field things--------------------------------

  public void saveFieldData(String field) {
    if (field.equals("annotations"))
      Debug.noteln("Cannot save annotations yet");
    else 
      //the refinements field cannot be updated from the global domain editor
      if (!field.equals("refinements") && !field.equals("objectClasses")) 
	super.saveFieldData(field);
  }
  /** reads panel components */
  public Object getFieldData(String field) {
    //refinements and object classes cannot be updated from the global editor
    if (field.equals("refinements") ||
	field.equals("objectClasses")) return null;
    else return super.getFieldData(field);
  }
  /* sets panel components */
  public void setFieldData(String field, Object value) {
    if (field.equals("refinements")) updateTable();
    else if (field.equals("objectClasses")) {//updateList();
      //Debug.noteln("GlFoP: setting object classes to", value);
      updateList();
    }
    else super.setFieldData(field, value);
    
  }


  //----------------------------UIDomainListening things--------------------

  public void refinementAdded(RefinementEvent e) {
    //tableModel.addData(e.getRefinement());
    //if (!getUIDomain().loading) updateTable();
  }
  public void refinementRemoved(RefinementEvent e) {
    //tableModel.removeData(e.getRefinement());
    //updateTable();
    //tableModel.setData(getUIDomain().getAllRefinements());
  }
  public void constructAdded(DomainEvent e) {}
  public void constructAdded(UIDomainEvent e) {
  //tableModel.addData(e.getObject());
    //if (!getUIDomain().loading) updateTable();
  }
  public void constructRemoved(UIDomainEvent e) {
    //tableModel.removeData(e.getObject());
    //updateTable();
    updateList();
  }
  public void constructEdited(UIDomainEvent e) {
    //tableModel.removeData(e.getObject());
    //tableModel.addData(e.getObject());
    //updateTable();
  }
  public void domainCleared(UIDomainEvent e) {
    //tableModel.clearData();
  }
  public void domainEdited(UIDomainEvent e) {
    //Debug.noteln("GFoP: domain edited", e.getDomain().getName());
    //getModel().setObject(e.getDomain());
    updateTable();
    updateList();
  }
  public void domainSet(UIDomainEvent e) {
    getModel().setObject(e.getDomain());
    //updateTable();
  }

  /*****Todo: preserve expansions */
  public void updateTable() {
    //Debug.noteln("GFoP: updating table");
    //Object o = table.getSelectedObject();
    tableModel.reloadData();
    table.setSelectedObject(currentAction);
  }
  public void updateList() {
    //Debug.noteln("GFoP: updating list");
    //Object o = table.getSelectedObject();
    //getModel().
    super.setFieldData("objectClasses", getUIDomain().getAllObjectClasses());
  }

  //----------------------------Construct Editing things-----------------------

  public UIDomain getUIDomain() {
    return parent.getUIDomain();
  }
  public void setConstruct(IXObject construct) {
    setUIConstruct(getUIDomain().getUIObject(construct));
  }
  public IXObject getConstruct() {
    if (uiConstruct == null) return null;
    else return uiConstruct.getBaseObject();
  }
  public void setUIConstruct(UIObject construct) {
    setUIConstructOnly(construct);
  }
  public void setUIConstructOnly(UIObject construct) {
    UIObject old = uiConstruct;
    uiConstruct = construct;
    getModel().setObject(construct);
    parent.fireConstructChanged(old, construct, this);
  }
  public UIObject getUIConstruct() {
    return uiConstruct;
  }

  public void loadFromObject() {
    displayModelData();
  }

  //----------------------------Listener things--------------------

  public void mouseClicked(MouseEvent event) {
    Component component = event.getComponent();
    //component.requestFocus();
    //Debug.noteln("GlobalFramePanel: mouse from ", component.getClass());
    //Debug.noteln(" parent", component.getParent()); //IXButPanel

    //only interested buttons on IXEditorPanels
    if ((component instanceof AbstractButton) &&
	(component.getParent().getParent() instanceof IXEditorPanel)) { 
      AbstractButton button = (AbstractButton) component;

      Component edPan = component.getParent().getParent(); //IXEditorPanel
      String panName = ((IXEditorPanel)edPan).getName();
      //Debug.noteln(" editor panel is", panName);
    
      if (panName != null) {
	  //Debug.noteln("GFoP: Button command " + button.getText());
	if (button.getText() == "Add") {
	  if (panName.equals("ObjectClasses")) {
	    String message = 
	      "Please use the Objects panel to add object classes."; 
	    JOptionPane.showMessageDialog(this.parent, message);
	  }
	  else if (panName.equals("Refinements")) {
	    getEditor().setConstruct(new Refinement());
	  }
	}
	else if (button.getText() == "Delete") 
	  userDeleteItem((IXEditorPanel)edPan);
	else if (button.getText() == "Edit") 
	  userEditItem((IXEditorPanel)edPan);
      }
    }
    super.mouseClicked(event); //notifies other mouse listeners

  }

  private List getClearSelection(IXEditorPanel edPan) {
    Component component =  edPan.getItemComponent();
    if (component instanceof IXTreeTable) {
      IXTreeTable table = (IXTreeTable)component;
      int[] rowNos = table.getSelectedRows();
      table.clearSelection();
      if (rowNos.length == 0) {
	complainNoSelection(edPan); 
	return null;
      }
      else {
	List selections = new ArrayList();
	AbstractIXTableModel model = (AbstractIXTableModel)table.getModel();
	for (int i = 0; i < rowNos.length; i++) {
	  selections.add(model.getRowObject(rowNos[i]));
	}
	return selections;
      }
    }
    else if (component instanceof JList) {
      List selections = Arrays.asList(((JList)component).getSelectedValues());
      ((JList)component).clearSelection();
      if ((selections == null) || selections.isEmpty()) {
	complainNoSelection(edPan);
	return null;
      }
      else return selections;
    }
    return null;
  }

  private void complainNoSelection(IXEditorPanel edPan) {
    String message = "Please select an item from the list first.";
    JOptionPane.showMessageDialog(this.parent, message);
  }

  private void userDeleteItem(IXEditorPanel edPan) {
    //Debug.noteln("GlFoP: user delete item");
    List objects = getClearSelection(edPan);
    //delete the refinement from the UIDomain
    if (objects != null) {
      for (Iterator i = objects.iterator(); i.hasNext(); ){
	Object item = i.next();
	try { getUIDomain().removeConstruct((UIObject)item); }
	catch (ClassCastException ce) { 
	  try { getUIDomain().removeConstruct((Named)item); }
	  catch (ClassCastException e) { 
	    Debug.noteln("Domain Editor: Cannot delete things of class", 
			 item.getClass().getName());
	    //Debug.noteException(e);
	  }
	}
      }
    }
  }

  private DomainEditor getEditor() {
    return (DomainEditor)parent.parent.editor();
  }
      
  private void userEditItem(IXEditorPanel edPan) {
    List selections = getClearSelection(edPan);
    if ((selections != null) && !selections.isEmpty()) {
      //just pick the first selection
      Object selection = selections.get(0);
      //show the right EditorPanel via parent, setConstruct on the panel
      try { getEditor().setConstruct((IXObject)selection); }
      catch (ClassCastException xe) { 
	try { getEditor().setUIConstruct((UIObject)selection); }
	catch (ClassCastException ue) { 
	  try { 
	    UINodeSpec node = (UINodeSpec)selection;
	    UIRefinement uir = new UIRefinement(getUIDomain());
	    uir.setPattern(node.getPattern());
	    uir.setName("undefined");
	    getEditor().setUIConstruct(uir); 
	  }
	  catch (ClassCastException ne) { 
	    Debug.noteln("Domain Editor: Cannot edit things of class", 
			 selection.getClass().getName());
	    //Debug.noteException(ne);
	  }
	}
      }
    }
  }

  public void valueChanged(ListSelectionEvent lse) {
    UIRefinement old = currentAction;
    int row = table.getSelectedRow();
    //Debug.noteln("GFoP: selected row is", row);
    if ((row != -1) && (row < table.getRowCount())) {
      Object object = tableModel.getRowObject(row);
      if (object instanceof UIRefinement) {
	UIRefinement act = (UIRefinement)object;
	currentAction = act;
	fireCurrentActionChanged(old, act);
      }    
    }
  }

  public void addCurrentActionListener(CurrentActionListener cal) {
    actionListeners.add(cal);
  }

  private void fireCurrentActionChanged(UIRefinement old, UIRefinement act) {
    if (reactingActionChange) return;
    if (((old == null) && (act == null)) ||
	((old != null) && (old.equals(act)))) return;
    //actual change, so pass on to interested parties
    for (Iterator i=actionListeners.iterator(); i.hasNext();) {
      CurrentActionListener cal = (CurrentActionListener)i.next();
      cal.actionChanged(this, old, act);
    }
    if ((act == null) || act.isEmpty()) table.clearSelection();
  }

  /** do not fire change when someone else is making the change */
  private boolean reactingActionChange = false;
  public void reactingActionChange(boolean flag) { 
    reactingActionChange = flag;
  }

  public void setSelectedAction(UIRefinement newAction) {
    table.clearSelection();
    table.setSelectedObject(newAction);
  }


  private class DescriptionsRenderer extends IXLabelRenderer { //IXTextRenderer
    public DescriptionsRenderer(boolean b) {super(b);}

    public void setInfo(Object object){
      if (object == null) setText("");
      else {
	if (Annotations.class.isInstance(object)) {
	  //Object c = ((Annotations)object).getAnnotation((Object)"comments");
	  //setText(c.toString());
	}
      }
    }

  }

  


}

////Todo: sort out updates (listening to domain changes)
