/****************************************************************************
 * A static class for doing things with IXTree objects or their models
 *
 * @author Jussi Stader
 * @version 2.0
 * Updated: Thu Sep 14 12:58:20 2006
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.iface.ui.tree;

import ix.util.*;
import ix.util.lisp.*;
import ix.iface.ui.util.*;

import java.util.*;
import javax.swing.*;
import javax.swing.tree.*;
import java.awt.datatransfer.*;
import java.awt.dnd.*;

public class IXTrees  {
	
  public static final String ROOTNAME = "Root";


  /**
   * Makes a tree for the given IXTree object using the given list
   * of user objects. Creates a model from this, adds it to the tree.
   */
  public static TreeModel setupTreeModel(EditableTreeModel model, 
					 List userObjects) {
    if (model == null) return null;
    model.clearModel();
    //if ((userObjects == null) || (userObjects.isEmpty())) return model;
    
    IXTreeNode root;
    //Debug.noteln("IXTrees: model setup nodes", UIUtil.show(userObjects));


    //find all roots
    List userRoots = findRoots(userObjects);
    //Debug.noteln(" found user roots", UIUtil.show(userRoots));
    //found no roots - something went wrong
    if ((userRoots == null) || (userRoots.size() == 0)) {
      if ((userObjects != null) && !userObjects.isEmpty())
	Debug.noteln("WARNING: IXTrees cannot find root in", userObjects);
      root = null;
    }
    //found one root - that's root
    else if (userRoots.size() == 1) {
      root = model.newIXTreeNode(userRoots.get(0));
      //Debug.noteln("Trees: made root from root", root);
    }
    //found more than one root - make root and hang all roots off this
    else {
      Object userRoot = model.makeUserObject(ROOTNAME, userRoots); 
      root = model.newIXTreeNode(userRoot);
      //Debug.noteln("Trees: made new root", root);
    }
    //Debug.noteln(" about to set root");
    model.setRoot(root);
    return model;
  }

 

    /**
     * Finds all roots in the list of TreeNode objects.
     * @param userNodes A list of user objects that implement TreeNode.
     * @return A list of User Objects (tree nodes) that have no parents.
     */
    public static List findRoots(List userNodes) {
	//Debug.noteln("IXTrees: finding roots");
	if (userNodes == null) return null;
	List roots = new ArrayList();
	for (Iterator i = userNodes.iterator(); i.hasNext(); ) {
	  IXNode node = (IXNode)i.next();
	  List parents = node.getParents();
	  if ((parents == null) || (parents.size() == 0)) roots.add(node);
	}
	//Debug.noteln(" found roots");
	return roots;
    }



    
}



  /**
   * Makes a tree for the given IXTree object using the given list
   * of user objects. Creates a model from this, adds it to the tree.
   */
/*
  public static TreeModel setupTreeModel(IXTree tree, List userObjects) {
    
    //HashMap nodeMap = new HashMap();
    IXTreeNode root;
    
    TreeModel model;
    //find all roots
    List userRoots = findRoots(userObjects);
    //found no roots - something went wrong
    if ((userRoots == null) || (userRoots.size() == 0)) {
      Debug.noteln("WARNING: IXTrees cannot find root in", 
		   userObjects);
      model = null;
    }
    //found one root - that's root
    else if (userRoots.size() == 1) {
      //return tree.makeTreeModel(root, nodeMap);
      model = tree.makeTreeModel(tree.newTreeNode(userRoots.get(0)));
    }
    //found more than one root - make root and hang all roots off this
    else {
      Object userRoot = tree.makeUserObject(ROOTNAME, userRoots); 
      root = tree.newTreeNode(userRoot);
      //nodeMap.put(userRoot.getName(), root);
      //return tree.makeTreeModel(root, nodeMap);
      model = tree.makeTreeModel(root);
    }
    if (model != null) tree.setModel(model);
    return model;
  }
*/
   /**
     * Makes a tree model from the root node. Also adds the model to the tree.
     * @param root A TreeNode that can either be a node in the tree or
     * a user object that implements IXNode. 
     * @return A TreeModel with a proper root.
     */
/*
    public static TreeModel setupTreeModel(IXTree tree, Object root) {
      if (root == null) return null;
      TreeModel model;
      if (root instanceof IXTreeNode)
	model = tree.makeTreeModel((IXTreeNode)root);
      else model = tree.makeTreeModel(tree.newTreeNode(root));
      tree.setModel(model);
      return model;
    }
*/
