/****************************************************************************
 * A JTree with user objects
 *
 * @author Jussi Stader
 * @version 2.0
 * Updated: Thu Sep 28 09:54:23 2006
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.iface.ui.tree;

import java.util.*;
import javax.swing.tree.*;
import javax.swing.JTree;


/****************************************************************************
 * A JTree with user objects. Format is very simple, with no icons. 
 *
 * Abstract methods to define:
 *  makeUserObject(String name, List userChildren)
 *
 *****************************************************************************
 */
public abstract class IXTree extends JTree {

  public IXTree() {
    super();
    formatTree();
  }
  public IXTree(TreeModel model) {
    super(model);
    formatTree();
  }

  protected void formatTree() {
    setAutoscrolls(true);
    getSelectionModel().
      setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
    setShowsRootHandles(false);
    setRootVisible(true);
    DefaultTreeCellRenderer renderer = 
      ((DefaultTreeCellRenderer)getCellRenderer());
    renderer.setLeafIcon(null);
    renderer.setOpenIcon(null);
    renderer.setClosedIcon(null);
  }

  public abstract Object makeUserObject(String name, List userChildren);

}
