/****************************************************************************
 * A popup menu that can be used as a cell editor for table cells instead of
 * combo boxes (they don't work properly).
 *
 * @author Jussi Stader
 * @version 1.0
 * Updated: Mon Jan 12 14:29:58 2004
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iface.ui.table;

import javax.swing.*;
import ix.util.Debug;
import ix.iface.util.RendererJLabel;
import ix.iface.ui.*;

import javax.swing.table.*;//table cell renderer etc.
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.*;
import javax.swing.table.*;
import javax.swing.border.Border;//label may have a border


/****************************************************************************
 * A popup menu that can be used as a cell editor for table cells instead of
 * combo boxes (they don't work properly).
 * 
 ****************************************************************************
 */
public class TablePopupMenu extends IXPopupMenu
{ 
  public int row = -1;
  public int column = -1;
  public JTable table;
  
  public TablePopupMenu(JTable table) {
    super();
    this.table = table;
  }
  public TablePopupMenu(String label) {
    super(label);
  }

  /**
   * Show the popup in the right position (under the cell) and remember which
   * cell is being edited.
   */
  public void show(MouseEvent me, int row, int column) {
    setCell(row, column);
    Rectangle rect = table.getCellRect(row, column, false);
    super.show(me.getComponent(), 
	       (int)rect.getX(), 
	       (int)(rect.getY() + rect.getHeight()));
    /* //setPopupSize makes no difference, setBounds removes menu!
    //Make sure the menu is at least as wide as the cell
    TableColumn col = table.getColumnModel().getColumn(column);
    int colWidth = col.getWidth();
    Debug.noteln("setting width to max of " + colWidth + " and ", getWidth());
    Debug.noteln(" new width " + getWidth() + " height ", getHeight());
    setBounds((int)rect.getX(), (int)(rect.getY() + rect.getHeight()),
	      Math.max(colWidth, getWidth()), getHeight());
    setPopupSize(Math.max(colWidth, getWidth()), getHeight());
    validate();
    Debug.noteln(" new width", getWidth());
    */
  }
  
  /**
   * Remember which table cell is being edited.
   */
  public void setCell(int row, int column) {
    this.row = row;
    this.column = column;
  }

  /**
   * Same as that for IXPopuoMenu, but uses plain font, not bold.
   */
  public JMenuItem add(FourField fourField) {
    JMenuItem jmi = super.add(fourField);
    if (jmi != null) {
      Font current = jmi.getFont();
      jmi.setFont(current.deriveFont(current.PLAIN));
    }
    return jmi;
  }

}

/**
 * Changes: 12/1/04 moved from ix.iface.ui to ix.iface.ui.table
 */
