/****************************************************************************
 * An interface that can listens to cells being clicked in tables.
 *
 * @author Jussi Stader
 * @version 1.0
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iface.ui.table;

import java.awt.event.*;

/****************************************************************************
 * An interface that can listens to cells being clicked in tables.
 *****************************************************************************
 */
public interface TableMouseListener {

  /**
   * Called when a cell has been clicked in the table.
   * To pick apart the mouse event, use code like this (interested in left
   * button clicks only):
   * <PRE><code>
   * int mod = me.getModifiers();
   * if (SwingUtilities.isLeftMouseButton(me)
   * ...}
   * </code></PRE>
   * @param me the original MouseEvent.
   * @param rowIndex the index of the row that has been clicked
   * @param columnIndex the index of the column that has been clicked
   */
  public void cellClicked(MouseEvent me, int rowIndex, int columnIndex);
}
