/****************************************************************************
 * An abstract class for tree table models.
 *
 * @author Jussi Stader
 * @version 1.0
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.iface.ui.table;

import ix.util.*;

import javax.swing.*;
import javax.swing.table.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.util.*;


/**************************************************************************
 * A protected class that is wrapped around TreeNode objects to hold 
 * information about identity in the tree (parent-line) and expansion
 * information (indentation, whether or not the node is expanded).
 **************************************************************************
 */
public class IXTNTreeTableNode extends IXTreeTableNode {
  public TreeNode node; //overwrites Object node in superclass
  
  public IXTNTreeTableNode(AbstractTreeTableModel model, TreeNode theNode) {
    this(model, theNode, null);
  }
  public IXTNTreeTableNode(AbstractTreeTableModel model, 
			   TreeNode theNode, List theParents) {
    super(model, theNode, theParents);
    node = theNode;    
  }
  public IXTNTreeTableNode(AbstractTreeTableModel model, 
			   TreeNode theNode, List theParents, int n) {
    this(model, theNode, theParents);
    indent = n;
  }
  public Enumeration children() { return node.children(); }
  public boolean getAllowsChildren() {return node.getAllowsChildren(); }
  public boolean isLeaf() {return node.isLeaf(); }
  public int getChildCount() {return node.getChildCount(); }
  public int getIndex(TreeNode child) {return node.getIndex(child); }
  public TreeNode getChildAt(int index) {return node.getChildAt(index); }
  public TreeNode getParent() {return node.getParent(); }
}
