/****************************************************************************
 * A simple panel with a label, a collection component, and optional buttons.
 *
 * @author Jussi Stader
 * @version 2.3+
 * Updated: Mon May 15 11:27:55 2006
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iface.ui;

import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import java.util.*;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.*;
import java.lang.reflect.Array;

import ix.util.Debug;
import ix.iface.ui.table.*;
import ix.iface.ui.tree.*;
    
/**
 * A simple panel with a label (title), a component, and optional
 * buttons.  The given label will be at the top, the given component
 * at the left and buttons with given labels on the right.  Listens to
 * the buttons and adds the given listener to the list (*not* the
 * buttons!).
 */
public class ToggleEditorPanel extends ListEditorPanel 
    implements ActionListener, ListSelectionListener, MouseListener
{
  private HashSet listeners = new HashSet();
  protected JToggleButton[] buttons;

  public ToggleEditorPanel() { super();}
  public ToggleEditorPanel(EventListener ml, String label, 
			   JToggleButton[] buttons) { 
    super(); 
    setLabel(label);
    
    //Debug.noteln("TogEdP: Making panel", label);
    //Debug.noteln(" with buttons", Arrays.asList(buttons));
    IXButPanel butPan = makeButtonPanel(this, buttons);
    makePanelComponent(ml, butPan);
    //Debug.noteln("TogEdP: button panel width is", butPan.getWidth());
    //Debug.noteln("TogEdP: data is", ((boolean[])getData()).length);
    listen(ml);
  }

  private void listen(EventListener ml) {
    if (ml instanceof ListSelectionListener) {
      addListSelectionListener((ListSelectionListener)ml);
    }
  }
  public boolean isListItem() {return true;}

  protected IXButPanel makeButtonPanel(EventListener ml, 
				       JToggleButton[] buts){
    IXButPanel butPan = new IXButPanel(ml, BoxLayout.X_AXIS, buts);
    this.buttons = buts;
    butPan.setPreferredSize(new Dimension(82*buts.length, 40));
    //this.setMinimumSize(new Dimension(100,50));
    return butPan;

  }


  /**
   * Gets the current data of toggle components.
   * @return an object that is an array of objects taken from the components.
   */
  public Object getData() {
    boolean[] settings = new boolean[buttons.length];
    for (int i = 0; i < buttons.length; i++) {
      JToggleButton button = buttons[i];
      settings[i] = button.isSelected();
    }
    return settings;
  }

  boolean isAdjusting = false;

  public void setListData(boolean[] data) {
    if (data.length != buttons.length) 
      Debug.noteln("WARNING: different length arrays setting list data!");
    else {
      isAdjusting = true;
      for (int i = 0; i < buttons.length; i++)
	buttons[i].setSelected(data[i]);
      isAdjusting = false;
    }
  }
  public void setListData(Object[] data) {
    if (data.length != buttons.length) 
      Debug.noteln("WARNING: different length arrays setting list data!");
    else {
      isAdjusting = true;
      for (int i = 0; i < buttons.length; i++) {
	Object val = data[i];
	if (val instanceof Boolean) 
	  buttons[i].setSelected(((Boolean)val).booleanValue());
	else {
	  Debug.noteln("TogEdP: got data of type", val.getClass());
	}
      }
      isAdjusting = false;
    }
  }

  /**
   * Sets the data of a collection component.
   * @param data an array of objects that is to be used as the data 
   */
  public void setData(Object data) {
    if (data instanceof Collection) setListData(((Collection)data).toArray());
    else if (data.getClass().isArray())	setListData((Object[])data);
    else Debug.noteln("TogEdP: cannot set data of class", data.getClass());
  }

  public void removeData() {
    for (int i = 0; i < buttons.length; i++) 
      buttons[i].setSelected(false);
  }

  public void setSelectedIndex(int index) {
    if (index < buttons.length) buttons[index].setSelected(true);
  }
  /** find the first button that is toggled on */
  public int getSelectedIndex() {
    int index = -1;
    for (int i = 0; (i < buttons.length) && (index < 0); i++) 
      if (buttons[i].isSelected()) index = i;
    return index;
  }

  public void setSelectedObject(Object object) {
    String name = object.toString();
    if (name == "") return;
    for (int i = 0; i < buttons.length; i++) 
      if (name.equals(buttons[i].getActionCommand())
	  || name.equals(buttons[i].getText())) {
	buttons[i].setSelected(true);
	return;
      }
  }
    
  /**
   * find the first button that is toggled on and return its command
   * or label
   */
  public Object getSelectedObject() {
    String name = "";
    for (int i = 0; i < buttons.length; i++) 
      if (buttons[i].isSelected()) {
	name = buttons[i].getActionCommand();
	if (name == "") 
	  name = buttons[i].getText();
	return name;
      }
    return name;
  }
  public boolean setRenderer(ListCellRenderer r) {
    return false;
  }

  public void addListSelectionListener(ListSelectionListener lsl) {
    if (lsl != null) listeners.add(lsl);
  }
  public void removeListSelectionListener(ListSelectionListener lsl) {
    if (lsl != null) listeners.remove(lsl);
  }

  public void mouseClicked(MouseEvent e){
    if ((e.getSource() == null) || isAdjusting) return;
    if (buttons.length > 0) 
      for (int i = 0; i < buttons.length; i++) 
	if (e.getSource().equals(buttons[i])) {
	  valueChanged(new ListSelectionEvent(e.getSource(), 0, 0, false));
	  return;
	}
  }
  public void valueChanged(ListSelectionEvent lse) {
    if (isAdjusting) return;
    if ((listeners != null) && !listeners.isEmpty()) 
      for (Iterator i = listeners.iterator(); i.hasNext(); ) {
	ListSelectionListener l = (ListSelectionListener)i.next();
	l.valueChanged(lse);
      }
  }
   
  public void actionPerformed(ActionEvent ae) {
    if (isAdjusting) return;
    Debug.noteln("TogEdP: got action", ae);
    if ((ae.getSource() != null) && (buttons.length > 0)) 
      for (int i = 0; i < buttons.length; i++) 
	if (ae.getSource().equals(buttons[i])) {
	  valueChanged(new ListSelectionEvent(ae.getSource(), 0, 0, false));
	  return;
	}
  }
  public void mouseEntered(MouseEvent e){}
  public void mouseExited(MouseEvent e){}
  public void mousePressed(MouseEvent e){}
  public void mouseReleased(MouseEvent e){}

}

/** ISSUES
 *
 */
