/****************************************************************************
 * A simple panel with a label, a text component, and optional buttons.
 *
 * @author Jussi Stader
 * @version 2.3+
 * Updated: Mon Jul 21 13:26:30 2003
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iface.ui;

import javax.swing.*;
import javax.swing.text.JTextComponent;
import java.util.*;
import java.awt.event.*;

import ix.util.Debug;
import ix.iface.ui.util.*;
    
/**
 * A simple panel with a label (title), a component, and optional buttons.
 * The given label will be at the top, the given component at the left and
 * buttons with given labels on the right.
 * Adds the given listener to the buttons and the list.
 */
public class ThingEditorPanel extends AbstractEditorPanel {

        
  public ThingEditorPanel(){super();}
  public ThingEditorPanel(EventListener ml, String label, 
			  JComponent component) { 
    super(ml, label, component);
  }
  public ThingEditorPanel(EventListener ml, String label, String[] buttons) { 
    super(ml, label, buttons);
  }
  public ThingEditorPanel(EventListener ml, String label, 
			  JComponent component, String[] buttons) { 
    super(ml, label, component, buttons);
  }
  public ThingEditorPanel(EventListener ml, boolean bordered, String label, 
			  JComponent component) { 
    super(ml, bordered, label, component);
  }

  public boolean isListItem() { return false;}

  /**
   * Gets the current data of a text component.
   * @return data a string that contains the text from component.
   */
  public Object getData() {
    return ((JTextComponent)this.itemComponent).getText().trim();
  }

  public JTextComponent getTextComponent() {
    if (this.itemComponent.getClass() == JScrollPane.class) {
      JScrollPane pane = (JScrollPane) this.itemComponent;        
      return (JTextComponent) pane.getViewport().getComponent(0);            
    } 
    else return (JTextComponent) this.itemComponent;
  }

  /**
   * Sets the current data of a text component.
   * @param data a string that contains the text to put into the component
   */
  public void setData(Object data) {
    try { //if you get an array, treat it as a list
      setData(Arrays.asList((Object[])data));
    }
    catch (Exception e) {
      JTextComponent textComp = getTextComponent();
      boolean enabled = textComp.isEnabled();
      //textComp.setEnabled(false);
      if ((data == null) || (data == "")) textComp.setText("");   
      else if (Collection.class.isInstance(data))
	textComp.setText(UIUtil.listToText((Collection)data));
      else textComp.setText(data.toString());  
      //focus problems if things are disabled! dont do it!
      //textComp.setEnabled(enabled);
    }
  }

  /**
   * Removes all text from the component.
   */
  public void removeData() {setData("");}

  public boolean setRenderer(ListCellRenderer r) {return false;}


  /** Makes the item (not) editable and enables (disables) the buttons */
  public void setEnabled(boolean isEditable) {
    JTextComponent textComp = getTextComponent();
    if (textComp != null)
      textComp.setEditable(isEditable);
    super.setEnabled(isEditable);
  }
}
