/****************************************************************************
 * An interface for editing properties.
 *
 * @author Jussi Stader
 * @version 3.1
 * Updated: Mon Apr 25 16:21:45 2005
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iface.ui;

import ix.*;
import ix.util.*;
import ix.util.lisp.*;
import ix.iface.ui.util.*;

import java.io.*;
import java.util.*;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Component;
import java.awt.event.*;
import javax.swing.*;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/**
 * An interface for editing properties.
 *
 * Remember to mark properties that cannot be edited in the property
 * manager, otherwise such preperties will be emptied.
 */
public interface JPropertiesEditor 
{

  /**
   * Show the editor so that the properties can be edited. This should
   * make sure that the current property values are shown in the
   * window's components.
   */
  public void show();

  /**
   * Looks up the current (old?) values of the given properties and
   * set the editor's components to the property values.
   */
  public void setComponentsFromProperties(Properties props);

  /**
   * Looks up the current (new) values of the properties in the
   * editor's components and puts them into the given properties
   * object. Only fires changes if the given fire flag is set.
   */
  public void getPropertiesFromComponents(Properties props, 
						   boolean fire);
  /**
   * As above, but works on the property manager's properties.
   */
  public void getPropertiesFromComponents(boolean fire);


  public void makeComponents();
  /** Sets the given dialog components for the given key with the value.
   *  @return true if there are components to be set, false otherwise. 
   */
  public boolean setComponentFromProperty(String key, List components, 
					  String val);
  public String getPropertyFromComponent(String key, List components);
  /** for buttons etc within the panel */
  public void localCommandClicked(String command);

  public void addPropertyChangeListener(PropertyChangeListener listener);
  public void removePropertyChangeListener(PropertyChangeListener listener);
 
  
}


/** Changes
 *
 * 16/02/04: documentation
 *
 */
