/****************************************************************************
 * An interface for things that are interested in new constraints.
 *
 * @author Jussi Stader
 * @version 1.0
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iface.ui;

import ix.*;

/****************************************************************************
 * An interface for things that are interested in new constraints.
 * A ConstraintEditor will call its registered listeners gotConstraint methods
 * when a new constraint has been made.
 *
 *****************************************************************************
 */
public interface JConstraintListener {
  /**
   * Implement this method to process the new constraint
   * @param e - the editor which made the constraint
   * @param o - the object for which the constraint has been made
   * @param constraint - the new constraint
   */
  public void gotConstraint(JConstraintEditor e, Object o, Object constraint);
}
