/****************************************************************************
 * A renderer for list or table cells. Can use text, colour, symbol, maybe 
 * image.
 *
 * @author Jussi Stader
 * @version 1.0
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iface.ui;

// needs class TwoField in ix.iface

import javax.swing.*;//jtable, list cell renderer etc
import ix.*;
import ix.util.Debug;
import ix.iface.util.*;

import javax.swing.table.*;//table cell renderer etc.
import java.awt.Component;
import java.awt.Color;
import java.awt.Font;
import javax.swing.border.Border;//label may have a border


/****************************************************************************
 * A renderer for list or table cells. Can use text, colour, symbol, maybe 
 * image.
 * 
 * Expects to use a TwoField, ThreeField or FourField object to obtain up
 * to four values, which are represented using text, colour, an image and a 
 * symbol.<p>
 *
 * The IXRenderer is created with a boolean argument which determines whether
 * the cell has a border or not. The border is used to show whether the
 * cell/row is selected or not.<p>
 *
 * The fields unselectedBorder, selectedBorder, and isBordered are
 * used to handle the borders of the cell if it has one.
 *
 * The class sub-classes RendererJLabel rather than JLabel for performance
 * reasons (see Java API documentation of TableCellRenderer or 
 * ListCellRenderer for more detail).
 *
 ****************************************************************************
 */
public interface IXRenderer extends TableCellRenderer, ListCellRenderer
{ 
  

  /*
  public void setLined(boolean isLined);
  public void setBorderSize(int width, int height); 
  public void setBold(boolean bold);
  */

  /**
   * Renders a table cell in colour and text. (Public due to interface).
   */
  /*
  public Component getTableCellRendererComponent(JTable table, Object object,
						 boolean isSelected, 
						 boolean hasFocus, 
						 int row, int column);
						 */
  /**
   * Renders a list cell in colour and text. (Public due to interface).
   */
  /*
  public Component getListCellRendererComponent(JList list, Object object,
						int index,
						boolean isSelected, 
						boolean hasFocus)
						*/
  /**
   * Provides the information to be displayed.
   * <p>Example1:
   * <PRE><code>
   *  protected void setInfo(Object object) {
   *    if (object == null) setText("");
   *    else setText(((UIRefinement)object).getName());
   *  }
   * </code></PRE>
   * Example2 (NDRenderer):
   * <PRE><code>
   *    protected void setInfo(Object object) {
   *        FourField fourField = (FourField) object;
   *        Color colour = (Color) fourField.toColour();
   *        if (colour != null) this.setBackground(colour);
   *        char fieldSymbol = fourField.toSymbol();
   *        String fieldString = fourField.toString();
   *        if (java.lang.Character.isDefined(fieldSymbol)) {
   *          this.setText((String) fieldString + " " + fieldSymbol);}
   *        else this.setText((String) fieldString);
   *        Icon fieldIcon = fourField.toImage();
   *        if (fieldIcon != null) this.setIcon(fieldIcon);
   *    }
   * </code></PRE>
   */
  public void setInfo(Object object);

}

