/****************************************************************************
 * A renderer for list or table cells. Can use text, colour, image, symbol.
 *
 * @author Jussi Stader
 * @version 1.0
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iface.ui;

import javax.swing.*;//jtable, list cell renderer etc
import ix.util.Debug;
import ix.iface.util.RendererJLabel;

import javax.swing.table.*;//table cell renderer etc.
import java.awt.Component;
import java.awt.Color;
import java.awt.event.*;
import javax.swing.border.Border;//label may have a border


/****************************************************************************
 * A renderer for list or table cells. Can use text, colour, image, symbol.
 * 
 * Expects to use a TwoField, ThreeField or FourField object to obtain up
 * to four values, which are represented using text, colour, an image and a 
 * symbol.<p>
 *
 * The IXRenderer is created with a boolean argument which determines whether
 * the cell has a border or not. The border is used to show whether the
 * cell/row is selected or not.<p>
 *
 * The fields unselectedBorder, selectedBorder, and isBordered are
 * used to handle the borders of the cell if it has one.
 *
 * The class sub-classes RendererJLabel rather than JLabel for performance
 * reasons (see Java API documentation of TableCellRenderer or 
 * ListCellRenderer for more detail).
 *
 ****************************************************************************
 */
public abstract class IXPopupMenu extends JPopupMenu
{ 
  
  public IXPopupMenu() {
    super();
    addMouseListener(new MouseAdapter() {
      public void mouseEntered(MouseEvent me) {
	//Debug.noteln("IXPM: listening to enter mouse");
	try {
	  //de-arm the current
	  MenuElement[] elements = getSubElements();
	  int i = getSelectionModel().getSelectedIndex();
	  //Debug.noteln(" selected is:", i);
	  if (i >= 0) {
	    JMenuItem selected = (JMenuItem)elements[i];
	    selected.setArmed(false);
	  }
	  //make sure one is armed ***TODO
	}
	catch (Exception e) {}	
      }
    });
  }
  public IXPopupMenu(String label) {
    this();
    setLabel(label);
  }

  public JMenuItem add(String s) {
    return super.add(s);
  }
  public JMenuItem add(FourField fourField) {
    if (fourField == null) { return null; }

    JMenuItem jmi = new JMenuItem();
    
    //For each 4 components - get and set it, if there is one
    //---colour
    if (fourField.hasColour() && (fourField.toColour() != null)) 
      jmi.setBackground(fourField.toColour());
    //--- symbol and string
    String fieldString = fourField.toString();
    if (fourField.hasSymbol() 
	&& (fourField.toSymbol() != null))
      jmi.setText((String) fieldString + " " + fourField.toSymbol());
    else jmi.setText((String)fieldString);
    //--- icon
    if (fourField.hasIcon() && (fourField.toIcon() != null))
      jmi.setIcon(fourField.toIcon());
    add(jmi);
    return jmi;    
  }


  public JMenuItem findMenuItem(String label) {
    if (label == null) return null;
    MenuElement[] elements = getSubElements();
    for (int i=0; i<elements.length; i++) {
      JMenuItem jmi = (JMenuItem)elements[i];
      if (label.equals(jmi.getText())) return jmi;
    }
    return null;
  }

  public void setSelected(JMenuItem jmi) {
    if (jmi != null) {
      MenuElement[] elements = getSubElements();
      for (int i=0; i<elements.length; i++) {
	JMenuItem otherJMI = (JMenuItem)elements[i];
	if ((jmi != otherJMI) && otherJMI.isArmed())
	  otherJMI.setArmed(false);
      }
      //Debug.noteln("IXPopM: setting current:", label);
      jmi.setArmed(true);
      super.setSelected(jmi);
    }
    //Debug.noteln("IXPopM: selected", getSelectionModel().getSelectedIndex());
  }
  public void setSelected(String label) {
    JMenuItem jmi = findMenuItem(label);
    setSelected(jmi);
    //Debug.noteln("IXPopM: selected", getSelectionModel().getSelectedIndex());
  }

  protected void clearArmed() {
    MenuElement[] elements = getSubElements();
    for (int i=0; i<elements.length; i++) {
      JMenuItem jmi = (JMenuItem)elements[i];
      if (jmi.isArmed()) jmi.setArmed(false);
    }    
  }

  /*
  public void menuSelectionChanged(boolean isIncluded) {
  //Debug.noteln("IXPopMen: menu selection changed");
    super.menuSelectionChanged(isIncluded);
  }
  */
  public void processMouseEvent(MouseEvent event) {
    //Debug.noteln("IXPopMen: mouse event", event);
    //Debug.noteln(" source", event.getSource());
    //if (MouseEvent.MOUSE_ENTERED == event.getSource())
    super.processMouseEvent(event);
  }
   

}

