/****************************************************************************
 * A frame with a menu bar to close it, and a scrollable text 
 *
 * @author Jussi Stader
 * @version 4.0+
 * Updated: Wed Nov 10 13:13:23 2004
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iface.ui;

import ix.*;
import ix.util.*;
import ix.iface.util.*;
import ix.iface.ui.util.*;

import java.util.*;
import java.awt.*;
import java.net.URL;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 * A frame with a menu bar to close it, and a scrollable text 
 */
public class HelpFrame extends HTMLFrame implements ActionListener
{
  
  final private URL original;
  //final private HTMLPanel htmlPanel;

  /**
   * Puts up an  HTML frame (menu bar, scrollable text area, text field,
   * follow links, back/forward) and keeps track of the original page,
   * Loads the given URL (/file name) as the original page.
   * An example call is <code> HelpFrame("ide-help.html") <\code>
   */
  public HelpFrame(URL url){
    super(url);
    original = htmlPanel.currentURL();
  }
  public HelpFrame(String fileName){
    super(fileName);
    original = htmlPanel.currentURL();
  }

  /**
   * As above but the given title
   */
  public HelpFrame(URL url, String title){
    super(url, title);
    original = htmlPanel.currentURL();
  }
  public HelpFrame(String fileName, String title){
    super(fileName, title);
    original = htmlPanel.currentURL();
  }
  	

  protected void setupFrame() {
    super.setupFrame();
  }

  //not used just now
  private void displayOriginal() {
    if (original != null)
      htmlPanel.displayURL(original);
    else 
      UIUtil.warning(this, "No original help page found");
  }

  public void actionPerformed(java.awt.event.ActionEvent event) {
    Object object = event.getSource();
    String command = ((AbstractButton)object).getActionCommand();
    //Debug.noteln("action object is",object);
    //Debug.noteln("HelpFrame: action command is",command);
    if (command == "original") this.displayOriginal();
    else super.actionPerformed(event);
  }
}
/*
 * Document all public methods
 */
