/****************************************************************************
 * An interface with four aspects: string, colour, symbol, image
 * 
 * @author Jussi Stader
 * @version 1.0
 */
package ix.iface.ui;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/****************************************************************************
 * An interface with four aspects: string, colour, symbol, image.
 * 
 * The four aspects can be displayed as one cell. They are of type 
 * <ul> String - to be represented by text
 * <li> Color - to be represented by background colour
 * <li> Icon - to be represented as an icon image
 * <li> char - to be represented as a symbol
 * <li> face - a flag to say whether the face is bold(true) or plain(false)
 * </ul>
 * Not all of the fields have to be set. Only the text is required (if there
 * is none, make toString return the empty string). Renderers should be able
 * to display what is set and determine how many dimensions are needed.
 *
 ****************************************************************************
 */
public interface FourField {
  public String toString();
  public Color toColour();
  public Icon toIcon();
  public int toFont();
  public Character toSymbol();
  public boolean hasColour();
  public boolean hasIcon();
  public boolean hasSymbol();
  public boolean hasFont();
}
