/****************************************************************************
 * An interface with four aspects: string, colour, symbol, image
 * 
 * @author Jussi Stader
 * @version 1.0
 */
package ix.iface.ui;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.ImageIcon;

import ix.util.*;

/****************************************************************************
 * An interface with four aspects: string, colour, symbol, image.
 * 
 * The four aspects can be displayed as one cell. They are of type 
 * <ul> String - to be represented by text
 * <li> Color - to be represented by background colour
 * <li> Icon - to be represented as an icon image
 * <li> char - to be represented as a symbol
 * </ul>
 * Not all of the fields have to be set. Only the text is required (if there
 * is none, make toString return the empty string). Renderers should be able
 * to display what is set and determine how many dimensions are needed.
 *
 ****************************************************************************
 */
public class EditableColourField extends DefaultColourField {
  public boolean editable = true;
  private static final ImageIcon editableIcon = 
     Util.resourceImageIcon("ix-symbol-editable.gif");
  private static final ImageIcon disabledIcon = 
     Util.resourceImageIcon("ix-symbol-editable-disabled.gif");

  public EditableColourField(String name, Color colour, boolean editable) {
    super(name, colour);
    this.editable = editable;
  }

  public Icon toIcon() {
    if (editable) return editableIcon;
    else return disabledIcon;
  }
  public boolean hasIcon() { return true;  }
}
