/****************************************************************************
 * An interface with four aspects: string, colour, symbol, image
 * 
 * @author Jussi Stader
 * @version 1.0
 */
package ix.iface.ui;

import java.awt.Font;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/****************************************************************************
 * An interface with four aspects: string, colour, symbol, image.
 * 
 * The four aspects can be displayed as one cell. They are of type 
 * <ul> String - to be represented by text
 * <li> Color - to be represented by background colour
 * <li> Icon - to be represented as an icon image
 * <li> sym - to be represented as a symbol/character
 * </ul>
 * Not all of the fields have to be set. Only the text is required (if there
 * is none, make toString return the empty string). Renderers should be able
 * to display what is set and determine how many dimensions are needed.
 *
 ****************************************************************************
 */
public class DefaultColourField implements FourField {
  String name = "";
  Color colour;
  int font = -1;
  Character sym;
  Icon icon;

  public DefaultColourField(String theName) {
    super();
    name = theName;
  }
  public DefaultColourField(String theName, Color theColour) {
    super();
    name = theName;
    colour = theColour;
  }
  public DefaultColourField(String theName, Color theColour, int theFont) {
    super();
    name = theName;
    colour = theColour;
    font = theFont;
  }
  public void setColour(Color theColour) {
    colour = theColour;
  }
  public void setString(String theString) {
    name = theString;
  }
  public void setIcon(Icon theIcon) {
    icon = theIcon;
  }
  public void setSymbol(Character theSymbol) {
    sym = theSymbol;
  }
  public void setFont(int theFont) {
    font = theFont;
  }

  public String toString() {return name;}
  public Color toColour() {return colour;}
  public Icon toIcon() {return icon;}
  public Character toSymbol() {return sym;}
  public int toFont() {return font;}
  public boolean hasColour() {return (colour != null);}
  public boolean hasIcon() {return (icon != null);}
  public boolean hasSymbol() {return (sym != null);}
  public boolean hasFont() {return (font != -1);}
}
