/****************************************************************************
 * A frame with a menu bar to close it, and a scrollable text 
 *
 * @author Jussi Stader
 * @version 4.0+
 * Updated: Wed Nov 10 13:14:04 2004
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iface.ui;

import ix.*;
import ix.util.*;
import ix.iface.util.*;
import ix.iface.ui.util.*;

import java.util.*;
import java.awt.*;
import java.net.URL;
import java.io.IOException;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 * A frame with a menu bar to close it, and a scrollable, enabled, but
 * non-editable text area. 
 * Example for using DomainEditor:
 * <PRE><code>
 *   ...
 *   protected AboutFrame aboutFrame;
 *   ...
 *    if (aboutFrame == null) {
 *      String[] message = {"About " + getTitle(),
 *			  IVUtil.ideReleaseToString()};
 *      aboutFrame = new AboutFrame(message);
 *    }
 *    aboutFrame.setVisible(true);
 *   ...
 * </code></PRE>
 *
 * or use the following combination:
 * <PRE><code>
 *   protected AboutFrame aboutFrame = new AboutFrame();
 *   ...
 *   aboutFrame.displayText(message);
 *   ...
 * </code></PRE>
 * the displayText methods will add the IX-version and date, the setText
 * methods just set the given text.
 */
public class AboutFrame extends ToolFrame 
  implements ActionListener// , HyperlinkListener 
{
  
  private JTextArea textPane = new JTextArea();
  private URL original;

  /**
   * Puts up a frame with a menu bar and a scrollable text area that can
   * display HTML (including images), follow links when clicked, and select
   * text, but NOT edit.
   */
  public AboutFrame(){
    super();
    getContentPane().setLayout(new BorderLayout(0,0));

    JMenuBar menuBar = new JMenuBar();
    setJMenuBar(menuBar);
    JMenu fileMenu = new JMenu("File");	 
    menuBar.add(fileMenu);
    JMenuItem item = new JMenuItem("Close");	 
    item.setActionCommand("close");
    item.addActionListener(new CatchingActionListener(this));
    fileMenu.add(item);

    textPane.setEditable(false);
    //textPane.addHyperlinkListener(this);
    JScrollPane textView = new JScrollPane(textPane);
    getContentPane().add(BorderLayout.CENTER, textView);

    setTitle("About");
    pack();
    setSize(250,200);
    setBounds(100, 100, 250,200);
    validate();
  }

  /**
   * As above but the given URL is displayed and remembered as the original
   * page.
   */
  public AboutFrame(ImageIcon icon, String initText){
    this();	
    displayIconText(icon, initText);
  }
  /**
   * As above but the given file name is converted to a URL using the text
   * area of the resources. 
   * An example call is <code> AboutFrame("ide-help.html") <\code>
   */
  public AboutFrame(String initText){
    this();	
    try {
      displayText(initText);
    }
    catch (Exception e) {
      Debug.noteException(e);
    }
  }
  /**
   * As above but the given file name is converted to a URL using the text
   * area of the resources. 
   * An example call is <code> AboutFrame("ide-help.html") <\code>
   */
  public AboutFrame(String title, String initText){
    this(initText);	
    setTitle(title);
  }
  /**
   * As above but the given file name is converted to a URL using the text
   * area of the resources. 
   * An example call is <code> AboutFrame("ide-help.html") <\code>
   */
  public AboutFrame(String[] initText){
    this();	
    try {
      displayText(initText);
    }
    catch (Exception e) {
      Debug.noteException(e);
    }
  }
  /**
   * As above but the given file name is converted to a URL using the text
   * area of the resources. 
   * An example call is <code> AboutFrame("ide-help.html") <\code>
   */
  public AboutFrame(String title, String[] initText){
    this(initText);	
    setTitle(title);
  }
  	

  /**
   * Displays the given URL in the text area.
   */
  public void displayIconText(ImageIcon icon, String starter) {
    displayText(starter);
  }
  /** Sets the given text into the first line, then appends IX and Java
   *  versions in seperate lines.
   */
  public void displayText(String starter) {
    String text = " " + starter + UIUtil.lineSeparator +   
      " I-X version " + ix.Release.version + ", " + ix.Release.date +
      UIUtil.lineSeparator + " Java version " + 
      System.getProperty("java.version");
    setText(text);
  }
  /** As above, but puts each array element into its own line. */
  public void displayText(String[] starter) {
    String text = " ";
    for (int i=0; i<starter.length; i++) 
      text = text + UIUtil.lineSeparator + " " + starter[i];
    displayText(text);
  }

  /** Use this to set the whole text to the given one. */
  public void setText(String text) {
    textPane.setText(text);
  }
  /** As above, but puts each array element into its own line.  */
  public void setText(String[] textList) {
    String text = " ";
    for (int i=0; i<textList.length; i++) 
      text = text + UIUtil.lineSeparator + " " + textList[i];
    setText(text);
  }

  /** As above, but puts starter at the start, then
   * each array element into its own line.  
   */
  public void setText(String starter, String[] textList) {
    String text = starter + UIUtil.lineSeparator;
    for (int i=0; i<textList.length; i++) 
      text = text + UIUtil.lineSeparator + " " + textList[i];
    setText(text);
  }

  public void actionPerformed(java.awt.event.ActionEvent event) {
    Object object = event.getSource();
    String command = ((AbstractButton)object).getActionCommand();
    //Debug.noteln("action object is",object);
    Debug.noteln("AboutFrame: action command is",command);
    if (command == "close") this.setVisible(false);
    else {
      String txt = ((AbstractButton)object).getText();
      if ((txt == "") || txt == null) txt = command;
      UIUtil.notImplemented(this, txt);
    }
  }
}
/*
 * Document all public methods
 */
/**
 * Changes:
 *  09/02/04: shows Java version
 *
 */
