/****************************************************************************
 * The value of an attribute of a piece of information or a relationship
 *
 * @author Jussi Stader
 * @version 3.1
 * Updated: Mon Mar  8 11:42:45 2004
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.icore.info;

import java.util.*;
import javax.swing.tree.*;

import ix.util.*;
import ix.iface.ui.util.*;
import ix.iface.ui.event.*;
import ix.util.lisp.*;
import ix.util.match.*;
import ix.icore.*;

/**
 * The value of an attribute of a piece of information or a relationship
 */

public class IValue extends AbstractAnnotatedObject implements IThing
{
  public IObject parent; //concept or rel or constraint
  public ISource source =  new ISource("default"); //default
  public int opinion = -1; //default
  public String attribute; //the attribute of the value
  public List constraints = new ArrayList();
  public Object value;

  public IValue(IObject parent, String attribute, Object value) {
    super();
    this.parent = parent;
    this.attribute = attribute;
    this.value = value;
  }

  public IValue(IObject parent, String attribute, Object value, 
		ISource source) {
    this(parent, attribute, value);
    this.source = source;
  }



  //---------------------Get/Set things-------------------------------------

  public void setValue(Object value) {
    this.value = value;
  }
  public void setSource(ISource source) {
    this.source = source;
  }
  public void setOpinion(int opinion) {
    this.opinion = opinion;
  }
  public void setAttribute(String attribute) {
    this.attribute = attribute;
  }
  public void setParent(IObject parent) {
    this.parent = parent;
  }

  public Object getValue() {
    return value;
  }
  public ISource getSource() {
    return source;
  }
  public int getOpinion() {
    return opinion;
  }
  public String getAttribute() {
    return attribute;
  }
  public IObject getParent() {
    return parent;
  }

  //---------------------Get/Set things-------------------------------------

  public boolean equals(Object iValue) {
    IValue value = (IValue)iValue;
    return (value.equals(value.getValue())
	    && source.equals(value.getSource())
	    && (opinion == value.getOpinion()));
  }
}


