/****************************************************************************
 * A type of concept or relationship.
 *
 * @author Jussi Stader
 * @version 3.1
 * Updated: Thu Mar 18 15:02:48 2004
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.icore.info;

import java.util.*;

import javax.swing.tree.*;

import ix.util.*;
import ix.iface.ui.util.*;
import ix.iface.ui.event.*;
import ix.util.lisp.*;
import ix.util.match.*;
import ix.icore.*;
import ix.icore.domain.Constraint;

/**
 * A type of concept or relationship.
 */

public class IType implements ix.icore.domain.Named, MutableTreeNode
{
  public String name;
  public IType parent;
  public List children = new ArrayList();
  public List attributes = new ArrayList();
  public Collection constraints = new HashSet();

  /** 
   * This constructor should only be used by an ITypeManager.
   * Use defineType of that class instead.
   */
  protected IType(IType parent, String name, List attributes) {
    super();
    this.parent = parent;
    this.name = name;
    this.attributes = attributes;
  }


  public Collection getAttributes() {
    return attributes;
  }
  public void setAttributes(List attributes) {
    this.attributes = attributes;
  }
  public void addAttribute(String attribute) {
    attributes.add(attribute);
  }
  public Collection getConstraints() {
    return constraints;
  }
  public void setConstraints(Collection constraints) {
    this.constraints = constraints;
  }
  public void addConstraint(Constraint constraint) {
    constraints.add(constraint);
  }

  public String getName() { return name; }
  public void setName(String name) {
    String old = this.name;
    this.name = name; 
  }
  /*
  public IType getParent() {
    return parent;
  }
  */
  public Collection getChildren() {
    return children;
  }

  public boolean checkConsistency() {
    return true;
  }
  
  
  //-----------------------TreeNode things-------------------------------------

  private static final int NOFIND = -1;
  public Enumeration children() { 
    return new Enumeration() {
      int i = children.size()-1;
      public boolean hasMoreElements() { return i >= 0; }
      public Object nextElement() { return children.get(i--); }
    };
  }
  public boolean getAllowsChildren() { return true; }
  public TreeNode getChildAt(int index) { 
    return null;//dummy
  }
  public int getChildCount() { return children.size(); }
  public int getIndex(TreeNode node) {
    return NOFIND;//dummy
  }
  public TreeNode getParent() { return (TreeNode)parent; }//one level deep only
  public boolean isLeaf() { return (getChildCount() == 0);}


  //-------------MutableTreeNode things
  // Adds child to the receiver at index.
  public void insert(MutableTreeNode child, int index) {
    children.add(index, child);
  }
  // Removes the child at index from the receiver.
  public void remove(int index) {
    children.remove(index);
  }
  // Removes node from the receiver.
  public void remove(MutableTreeNode node) {
    int index = children.indexOf(node);
    remove(index);
  }
  // Removes the receiver from its parent.
  public void removeFromParent() {
    parent.remove(this);
  }          
  // Sets the parent of the receiver to newParent.
  public void setParent(MutableTreeNode newParent) {
    this.parent = (IType)newParent;
  }
          
  // Resets the user object of the receiver to object.
  public void setUserObject(Object object) {
    
  }
}

// Issues:

