/****************************************************************************
 * The value of an attribute of a piece of information or a relationship
 *
 * @author Jussi Stader
 * @version 3.1
 * Updated: Mon Mar  8 15:30:46 2004
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.icore.info;

import java.util.*;
import javax.swing.tree.*;

import ix.util.*;
import ix.iface.ui.util.*;
import ix.iface.ui.event.*;
import ix.util.lisp.*;
import ix.util.match.*;
import ix.icore.*;

/**
 * The value of an attribute of a piece of information or a relationship
 */

public class ISource extends AbstractAnnotatedObject 
  implements IThing, ix.icore.domain.Named
{

  protected String name;
  protected int defaultQuality = 0;
  /**
   * A map that takes the combined type-attribute to get the quality value
   * for the attribute in that type 
   */
  protected HashMap attQuality = new HashMap();
  

  public ISource(String name) {
    super();
    this.name = name;
  }


  //---------------------Get/Set things-------------------------------------

  public String getName() { return name; }
  public void setName(String name) {
    String old = this.name;
    this.name = name; 
  }

  public void setQuality(IType type, String attribute, int quality) {
    String key = type.getName() + "-" + attribute;
    attQuality.put(key, new Integer(quality));
  }
  public int getQuality(IType type, String attribute) {
    String key = type.getName() + "-" + attribute;
    Object quality = attQuality.get(key);
    if (quality == null) return defaultQuality;
    else {
      return ((Integer)quality).intValue();
    }
  }
  public int getQuality(IObject object, String attribute) {
    return getQuality(object.getType(), attribute);
  }


  //---------------------Get/Set things-------------------------------------

  public boolean equals(Object iSource) {
    return name.equals(((ISource)iSource).getName());
  }
}


