/****************************************************************************
 * A relationship between two or more pieces of information (concepts) with 
 * attribute values and constraints
 *
 * @author Jussi Stader
 * @version 3.1
 * Updated: Mon Mar  8 15:30:05 2004
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.icore.info;

import java.util.*;

import ix.util.*;
import ix.iface.ui.util.*;
import ix.iface.ui.event.*;
import ix.util.lisp.*;
import ix.util.match.*;
import ix.icore.*;

/**
 * A relationship between two or more pieces of information (concepts) with 
 * attribute values and constraints. 
 * For the moment, all relations are assumed to be binary (linking just two 
 * concepts).
 */

public class IRelation extends AbstractIObject 
{
    
  public IConcept fromConcept;
  public IConcept toConcept;

  public IRelation() {
    super();
  }

  public IRelation(IRelationType relationType) {
    super(relationType);
  }
  public IRelation(IRelationType relationType, IConcept from, IConcept to) {
    this(relationType);
    setRelation(from, to);
  }


  //-----------------------Get/Set things---------------------------------

  public void setRelation(IConcept from, IConcept to) {
    fromConcept = from;
    toConcept = to;
  }
  public void setFrom(IConcept from) {
    fromConcept = from;
  }
  public void setTo(IConcept to) {
    toConcept = to;
  }
  public IConcept getFrom() {
    return fromConcept;
  }
  public IConcept getTo() {
    return toConcept;
  }


  public boolean setAttributeValue(String attName, Object value) {
    try {
      if (attName.equals("fromConcept")) {
	setFrom((IConcept)value);
	return true;
      }
      else if (attName.equals("toConcept")) {
	setTo((IConcept)value);
	return true;
      }
      else return super.setAttributeValue(attName, value);
    }
    catch (Exception e) {
      Debug.describeException(e);
      return false;
    }	
  }

  public Object getAttributeValue(String attName) {
    try {
      if (attName.equals("fromConcept")) return getFrom();
      else if (attName.equals("toConcept")) return getTo();
      else return super.getAttributeValue(attName);
    }
    catch (Exception e) {
      Debug.noteException(e);
      return null;
    }
  }


  /**
   * A refinement is empty if all its data fields are empty.
   * Note: the refinement may not have started out as empty - check whether it
   * has a base-object for full emptiness.
   */
  public boolean isAttributesEmpty() {
    if ((fromConcept == null) && (toConcept == null))
      return super.isAttributesEmpty();
    else return false;
  }

  public boolean sameAttributeValue(String field, 
				    Object value, Object otherValue) {
    try {
      if (field.equals("fromConcept") || field.equals("toConcept"))
	return value.equals(otherValue);
      else return value.equals(otherValue);
    }
    catch (Exception e) {
      Debug.noteException(e);
      return false; //safe exit
    }
  }

  /**
   * Checks that the concepts are of the right type
   */
  public boolean checkConsistency() {
    Debug.noteln("IRelation: dummy", "checkConsistency");
    return true;
  }

  //-----------------------UI service things-----------------------------------



  //-----------------------Event things----------------------------------------


    
}

// Issues:

