/****************************************************************************
 * An interface to include all base objects that have to do with information
 * models. 
 *
 * @author Jussi Stader
 * @version 3.1
 * Updated: Mon Mar  8 15:24:00 2004
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.icore.info;

import ix.icore.*;
import ix.iface.ui.event.DataChangeListener;


/**
 * An interface to include all base objects that have to do with information
 * models, i.e. concepts and relations but not values.
 */

public interface IObject extends IThing, ix.icore.domain.Named
{
  public boolean setValue(IValue value);
  public boolean setValue(String attName, Object value);
  public Object getValue(String attName);
  public void setType(IType type);
  public IType getType();
  public boolean isEmpty();
  public boolean nameHasChanged(Object nameThing);
  public boolean sameValue(String field, Object value, Object otherValue);
  public boolean checkConsistency();
  public void addDataChangeListener(DataChangeListener l);
  public void removeDataChangeListener(DataChangeListener l);

}

// Issues:

