/****************************************************************************
 * A piece of information (issue, component, etc.) with attribute values
 * and relationships
 *
 * @author Jussi Stader
 * @version 3.1
 * Updated: Mon Mar  8 15:29:51 2004
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.icore.info;

import java.util.*;
import javax.swing.tree.*;

import ix.util.*;
import ix.iface.ui.util.*;
import ix.iface.ui.event.*;
import ix.util.lisp.*;
import ix.util.match.*;
import ix.icore.*;

/**
 * A piece of information (issue, component, etc.) with attribute values
 * and relationships
 */

public class IConcept extends AbstractIObject
{
    
  /** Names of attributes that are allowed for this concept */
  public HashSet attributes = new HashSet(); 
  public ArrayList parents = new ArrayList(); 
  public ArrayList children = new ArrayList(); 
  public boolean hasParents = false;

  protected HashMap attVals = new HashMap(); //maps att name to value thing


  public IConcept() {
    super();
  }

  public IConcept(IConceptType conceptType) {
    super(conceptType);
  }

  //-----------------------Get/Set things---------------------------------

  public boolean setAttributeValue(String attName, Object value) {
    if (attName.equals("type")) {
      setType((IConceptType)value);
      return true;
    }
    else return super.setAttributeValue(attName, value);
  }
  public Object getAttributeValue(String attName) {
    if (attName.equals("type")) return getType();
    else return super.getAttributeValue(attName);
  }

  public boolean sameAttributeValue(String att, Object val, Object otherVal) {
    return false; //safe exit
  }

  public boolean checkConsistency() {
    Debug.noteln("IConcept: dummy", "checkConsistency");
    return true;
  }

  //-----------------------UI service things-----------------------------------



  //-----------------------TreeNode things-------------------------------------

  
  private static final int NOFIND = -1;
  public Enumeration children() { 
    //nodes = this.getNodes();
    return new Enumeration() {
      /*
      int i = 0;
      public boolean hasMoreElements() { return i < nodes.size(); }
      public Object nextElement() { return nodes.get(i++); }
      */
      int i = children.size()-1;
      public boolean hasMoreElements() { return i >= 0; }
      public Object nextElement() { return children.get(i--); }
    };
  }
  public boolean getAllowsChildren() { return false; }
  public TreeNode getChildAt(int index) { 
    return null;//dummy
  }
  public int getChildCount() { return children.size(); }
  public int getIndex(TreeNode node) {
    return NOFIND;//dummy
  }
  public TreeNode getParent() { return null; }//one level deep only
  public boolean isLeaf() { return (getChildCount() == 0);}

}

// Issues:

