/****************************************************************************
 * An information thing - a concept, relationship between concepts...
 *
 * @author Jussi Stader
 * @version 3.1
 * Updated: Mon Mar  8 15:25:51 2004
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.icore.info;

import java.util.*;

import ix.util.*;
import ix.iface.ui.util.*;
import ix.iface.ui.event.*;
import ix.util.lisp.*;
import ix.util.match.*;
import ix.icore.*;
import ix.iface.ui.event.DataChangeListener;

/**
 * An information thing - a concept, relationship between concepts...
 */

public abstract class AbstractIObject extends AbstractIXObject 
  implements IObject, ix.icore.domain.Named, ix.iface.ui.EditableObject
{
  public String name;
    
  protected HashMap attVals = new HashMap(); //maps att name to value thing

  protected IType type;


  public AbstractIObject() {
    super();
  }

  public AbstractIObject(IType type) {
    this();
    this.type = type;
  }


  //-----------------------Get/Set things---------------------------------

  public boolean setValue(IValue value) {
    if (value == null) return false;
    else return setValue(value.getAttribute(), value);
  }

  public boolean setValue(String attName, Object value) {
    //Debug.noteln("UIR: setting value for field", attName);
    if ((attName == null) || (attName == "")) return false;
    try {
      if (attName.equals("name")) setName((String) value);
      else if (attName.equals("comments")) setComments((String) value);
      else if (attName.equals("annotations")) 
	setAnnotations((Annotations) value);
      else if (attName.equals("annotation")) 
	takeAnnotations((Map) value);
      else if (setAttributeValue(attName, value)) return true;
      else {
	Debug.noteln("AbstractIObject cannot set value for field", 
		     attName + " (" + type + ")");
	return false;
      }
      return true;
    }
    catch (Exception e) {
      Debug.describeException(e);
      return false;
    }	
  }
  public boolean setAttributeValue(String attName, Object value) {
    if (getAttributes().contains(attName)) {
      attVals.put(attName, value);
      return true;
    }
    else return false;
  }

  public Object getValue(String attName) {
    if ((attName == null) || (attName == "")) return null;
    try {
      if (attName.equals("name")) return getName();
      else if (attName.equals("comments")) return getComments();
      else return getAttributeValue(attName);
    }
    catch (Exception e) {
      Debug.noteException(e);
      return null;
    }
  }

  /**
   * Looks up the list of allowed attributes.
   * @return a list of strings that are attribute names allowed for this
   * IObject type.
   */
  public Collection getAttributes() {
    return getType().getAttributes();
  }

  public Object getAttributeValue(String attName) {
    return attVals.get(attName);
  }

  public String getName() { return name; }
  public void setName(String name) {
    String old = this.name;
    this.name = name; 
    fireDataChange("name", old, name);
  }

  public IType getType() { return type; }
  public void setType(IType type) {
    IType old = this.type;
    this.type = type; 
    fireDataChange("type", old, type);
  }
  

  /**
   * A refinement is empty if all its data fields are empty.
   * Note: the refinement may not have started out as empty - check whether it
   * has a base-object for full emptiness.
   */
  public boolean isEmpty() {
    Debug.noteln("IThing: dummy", "isEmpty");
    if ((name == null || (name.equals("")))
	&& (getComments() == null || (getComments().equals("")))) {
      //Debug.noteln("IThing is empty");
      return isAttributesEmpty();
    }
    //Debug.noteln("thing is not empty");
    else return false;
  }

  public boolean nameHasChanged(Object nameThing) {
    String original = (String) nameThing;
    if ((((name == null) || name.equals("")) &&
	 ((original == null) || (original.equals("")))) ||
	((name != null) && name.equals(original)))
      return false;
    else return true;
  }

  public boolean sameValue(String field, Object value, Object otherValue) {
    if (field == null) return false;
    if (value == null) return isEmptyValue(otherValue);
    if (otherValue == null) return false;
    if (field.equals("name") || field.equals("comments"))
      return value.equals(otherValue);
    else return sameAttributeValue(field, value, otherValue);
  }

  public boolean isAttributesEmpty() {
    if (UIUtil.isEmptyValue(attVals)) return true;
    else {
      for (Iterator i = attVals.values().iterator(); i.hasNext(); ) {
	if (!isEmptyValue(i.next())) return false;
      }
      return true;
    }
  }
  
  /**
   * Checks whether the given value is empty. Overwrite this or add to it in 
   * subclasses.
   */
  public boolean isEmptyValue(Object value) {
    return UIUtil.isEmptyValue(value);
  }

  //-----------------------Abstract things-------------------------------------

  public abstract boolean sameAttributeValue(String attName, 
					     Object value, Object otherValue);


  public abstract boolean checkConsistency();


  //-----------------------Event things----------------------------------------

  HashSet dataChangeListeners = new HashSet();

  public void addDataChangeListener(DataChangeListener l) {
    dataChangeListeners.add(l);
  }
  public void removeDataChangeListener(DataChangeListener l) {
    dataChangeListeners.remove(l);
  }

  private void fireDataChange(String field, Object oldValue, Object newValue) {
    //Debug.noteln("UIR: changing value from", oldValue);
    //Debug.noteln(" to", newValue);
    if (sameValue(field, oldValue, newValue)) return; //no change
    for (Iterator i = dataChangeListeners.iterator(); i.hasNext(); ) {
      DataChangeListener l = (DataChangeListener)i.next();
      l.dataChanged(this, field, oldValue, newValue);
    }
  }

    
}

// Issues:

