@echo off
:: Script to start up an I-X Application
:: Austin Tate, AIAI, University of Edinburgh
:: Updated: Fri Feb 18 14:31:27 2005

if "%1"=="/?" goto HELP

:: expects set variables app_path, ix_base, java_params, app_params and ipc

:: within a variable usage i.e. %param% before the final %
::    :<character>= means remove all instanmces of the <character>
set temp1=%ix_base:"=%
if "%temp1%"=="" goto WRONG_LOCATION_IX

if not exist %ix_base%\scripts\win\run-ix-app.bat goto WRONG_LOCATION_IX

if not "%OS%"=="Windows_NT" goto RUN_APP
   :: commands that only work in Windows NT to improve appearance and behaviour
   pushd .
   setlocal
:RUN_APP

set ix_path=%ix_base%\ix.jar

:: >>>> use next 2 lines to override ix.jar with contents of java directory
:: set ix_path=%ix_base%\java;%ix_base%\ix.jar;
:: echo NOTE: overriding ix.jar with contents of ix_base\java directory

:: The all-imports.jar file contains a ClassPath entry in its manifest
:: that includes all the jars needed by the I-X.  There are variants for
:: the core I-X, or an extension that uses RDF and/or OWL.

set ix_path=%ix_path%;%ix_base%\imports\all-imports.jar

set ix_path=%ix_path%;%ix_base%\imports\jdom.jar
set ix_path=%ix_path%;%ix_base%\imports\mgraph.jar

:: BBN Openmap if required is now added specifically in an application
:: removed 31-Aug-2004 - set ix_path=%ix_path%;%ix_base%\imports\openmap.jar

:: note saxon.jar which may be present in the imports directory
:: for XSLT purposes is not required to run a normal I-X application
:: removed 11-Nov-2004 - set ix_path=%ix_path%;%ix_base%\imports\saxon.jar

if "%ipc%"=="" (
   set comms_base=
   set comms_path=
   goto END-SETVARS
)
if "%ipc%"=="simple" (
   set comms_base=
   set comms_path=
   goto END-SETVARS
)
if "%ipc%"=="xml" (
   set comms_base=
   set comms_path=
   goto END-SETVARS
)

set comms_base=%ix_base%\comms\%ipc%
call %comms_base%\scripts\win\comms-setvars.bat %ix_base%
:: above adds java_params for any required java parameters

:END-SETVARS

set all_path=%ix_path%

:: within a variable usage i.e. %param% before the final %
::    :<character>= means remove all instances of the <character>
set temp1=%comms_path:"=%
:: in case of param being unset then the above will introduce ="
:: remove these as they should not occur now
set temp1=%temp1:"=%
if "%temp1%"=="=" set temp1=
if not "%temp1%"=="" set all_path=%all_path%;%comms_path%

:: extra_path is usually null, but may be set in entry scripts to allow
:: any extra jars and classpath entries - e.g. for multiple comms strategies.

:: within a variable usage i.e. %param% before the final %
::    :<character>= means remove all instances of the <character>
set temp1=%extra_path:"=%
:: in case of param being unset then the above will introduce ="
:: remove these as they should not occur now
set temp1=%temp1:"=%
if "%temp1%"=="=" set temp1=
if not "%temp1%"=="" set all_path=%all_path%;%extra_path%

set java_params=-Dix.base=%ix_base% %java_params%

:: within a variable usage i.e. %param% before the final %
::    :<character>= means remove all instances of the <character>
set temp1=%app_path:"=%
:: in case of param being unset then the above will introduce ="
:: remove these as they should not occur now
set temp1=%temp1:"=%
if "%temp1%"=="=" set temp1=
if not "%temp1%"=="" set all_path=%app_path%;%all_path%

:: set default java command, but override if java-command.bat script exists
set java_command=java
if exist %ix_base%\scripts\win\java-command.bat call %ix_base%\scripts\win\java-command.bat

%java_command% -version

echo java call parameters are:
echo ----- classpath=%all_path%
echo ----- java_params=%java_params%
echo ----- %1
echo ----- app_params=%app_params%

:: note do not put quotes around all_path to ensure that pathnames within it
:: can contain quoted parts to protect spaces
%java_command% -classpath %all_path% %java_params% %1 %app_params%

if not "%OS%"=="Windows_NT" goto END
:: commands that only work in Windows NT to improve appearance and behaviour
endlocal
popd
goto END

:WRONG_LOCATION_IX
   echo run-ix-app.bat: ix_base not correctly set
   pause
   goto END

:HELP
   echo run-ix-app.bat app-class
   echo     app-class  - application class name (e.g. ix.ip2.Ip2)
   pause
   goto END

:END




