/* Author: Clauirton Siebra <c.siebra@ed.ac.uk>
 * Updated: Wen May 14 09:08:58 2002 by Clauirton Siebra
 * Copyright: (c) 2001-2003, AIAI, University of Edinburgh
 */

package ix.ip2.map;

import javax.swing.*;
import java.awt.event.*;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.util.*;

import ix.util.*;
import ix.util.lisp.*;
import ix.ip2.*;
import ix.icore.domain.PatternAssignment;
import ix.iface.util.CatchingActionListener;

/**
 * Class that creates the insert frame on empty places of the map, enabling the insertion of new objects.  
 */

public class InsertFrame extends JFrame implements ActionListener {

    JTextField objTF,latTF,lonTF,typeTF;
    StateViewer sv;
    Hashtable world;

    /**
     * Creates a insert frame with the latitude and longitude of the new object pointed by the mouse.
     * @param sv reference to state viewer. Via state viewer we are able to add a new object in the IP2 base. 
     * @param lat initial latitude of the new object.
     * @param lon initial longitude of the new object.
     * @param world table with all current objects of the environment.
     */
    public InsertFrame(StateViewer sv, float lat, float lon, Hashtable world) {
        super("Add Object");

        this.sv = sv;
        this.world = world;
        requestFocus();

        JPanel editP = new JPanel();
        editP.setLayout(new FlowLayout(FlowLayout.LEFT));
        JPanel buttonP = new JPanel();

        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(editP,BorderLayout.CENTER);
        getContentPane().add(buttonP,BorderLayout.SOUTH);

        JLabel objL = new JLabel("Object ID = ");
        editP.add(objL);
        objTF= new JTextField(12);
        editP.add(objTF);
    
        JLabel latL = new JLabel("latitude = ");
        editP.add(latL);
        latTF = new JTextField(Float.toString(lat),12);
        latTF.setEditable(false);
        editP.add(latTF);

        JLabel lonL = new JLabel("longitude = ");
        editP.add(lonL);
        lonTF = new JTextField(Float.toString(lon),12);
        lonTF.setEditable(false); 
        editP.add(lonTF);

        JLabel typeL = new JLabel("type (optional) = ");
        editP.add(typeL);
        typeTF= new JTextField(12);
        editP.add(typeTF);

        JButton addB = new JButton("Add");
        addB.addActionListener(CatchingActionListener.listener(this));
        buttonP.add(addB);

        JButton clearB = new JButton("Clear");
        clearB.addActionListener(CatchingActionListener.listener(this));
        buttonP.add(clearB);
    
        JButton cancelB = new JButton("Cancel");
        cancelB.addActionListener(CatchingActionListener.listener(this));
        buttonP.add(cancelB);

        setSize(250,190);
        setVisible(true);

        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                dispose();
            }
        });
    }
    
    /**
     * Controls the buttons' actions. The current are: Add, Cancel and Clear.
     * @param e event generated by one of the frame buttons.
     */ 
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Debug.noteln("Map Tool action:", command);
        if (command.equals("Cancel")) {
            dispose();
        }
        else if (command.equals("Add")) {
            if (objTF.getText().equals(""))
                Util.displayAndWait(this,"You need to set an ID to the new object");
            else if (world.containsKey(Symbol.intern(objTF.getText())))
                Util.displayAndWait(this,"ID already exist... you need to provide an unique ID");
            else {
                String obj = objTF.getText();
                if (!(typeTF.getText().equals("")))
                    sendConstraint(new PatternAssignment(Lisp.list(Symbol.intern("type"),Symbol.intern(obj)),Symbol.intern(typeTF.getText())));
                sendConstraint(new PatternAssignment(Lisp.list(Symbol.intern("latitude"),Symbol.intern(obj)),new Float(latTF.getText())));
                sendConstraint(new PatternAssignment(Lisp.list(Symbol.intern("longitude"),Symbol.intern(obj)),new Float(lonTF.getText())));
            }
            dispose();
        }
        else if (command.equals("Clear")) {
            objTF.setText("");
            typeTF.setText("");
            objTF.requestFocusInWindow();
        }
        else
            Debug.noteln("Nothing to do", command);
    }

    protected void sendConstraint(PatternAssignment pa) {
	if(sv instanceof ix.ip2.map.MapWhiteboard)
	    ((MapWhiteboard)sv).sendConstraint(pa);
	else
	   ((StateViewMap)sv).sendConstraint(pa);
    }
}
